/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.Id;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class GroupSearch extends IdSearch {

  /**
   * Gets or sets include Groups from all trees, for example "Security Groups" and "Private User Groups". The"Company
   * Group" tree is included by default.
   */
  private Boolean includeAllTrees;

  /**
   * Gets or sets gets maximum Id of the search criteria.
   */
  private Id maxId;

  /**
   * Gets or sets search for Groups with this Name. Wildcard can be used by prepending/appending "%" to string. Example
   * "%name%".
   */
  private String name;

  /**
   * Gets or sets search for Groups with this Reference. Wildcard can be used by prepending/appending "%" to string.
   * Example "%reference%".
   */
  private String reference;

  @Builder
  public GroupSearch(String id, Boolean includeAllTrees, Id maxId, String name,
      String reference) {
    super(id);
    this.includeAllTrees = includeAllTrees;
    this.maxId = maxId;
    this.name = name;
    this.reference = reference;
  }
}
