package com.geotab.model.search;

import com.geotab.model.entity.deviceconnectionstatus.DeviceConnectionStatus;
import com.geotab.model.entity.ioxaddonstatus.IoxAddOnStatus;
import java.time.LocalDateTime;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Gets or sets search for {@link IoxAddOnStatus} that are or have been attached to this {@link DeviceSearch} Id.
 * Available DeviceSearch options are:
 * <list>
 * <item>
 * <description>Id</description>
 * </item>
 * </list>
 */
@Data
@NoArgsConstructor
public class IoxAddOnStatusSearch implements Search {

  /**
   * Gets or sets search for {@link IoxAddOnStatus} that are or have been attached to this {@link DeviceSearch}.
   */
  private DeviceSearch deviceSearch;

  /**
   * Gets or sets the {@link DeviceConnectionStatus} (Active = 0, Inactive = 4, Disconnected = 1).
   */
  private int deviceConnectionStatus;

  /**
   * Gets or sets search for {@link IoxAddOnStatus} records that were logged at this date or after.
   */
  private LocalDateTime fromDate;

  /**
   * Gets or sets search for {@link IoxAddOnStatus} records that were logged at this date or before.
   */
  private LocalDateTime toDate;

  @Builder
  public IoxAddOnStatusSearch(DeviceSearch deviceSearch, int deviceConnectionStatus, LocalDateTime fromDate, LocalDateTime toDate) {
    this.deviceSearch = deviceSearch;
    this.deviceConnectionStatus = deviceConnectionStatus;
    this.fromDate = fromDate;
    this.toDate = toDate;
  }
}
