/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.dvirlog.DVIRLog;
import com.geotab.model.entity.file.MediaFile;
import java.time.LocalDateTime;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link DVIRLog}(s). A trailerSearch and deviceSearch
 * cannot be used at the same time because a DVIR log entry is only ever associated with one asset type (for instance,
 * if the "device" is set, "trailer" is always null and vice versa).
 */
@Data
@NoArgsConstructor
public class MediaFileSearch extends IdSearch {

  /**
   * Filter by the DeviceSearch options. Providing a device ID will search for any MediaFiles that are assigned to that
   * Device. Providing the Groups will search for MediaFiles for that have Devices in that group.
   *
   * <p>Available DeviceSearch options are:.
   * <ul>
   *    <li>Id</li>
   *    <li>Groups</li>
   * </ul>
   */
  private DeviceSearch deviceSearch;

  /**
   * Search for {@link MediaFile} with this UserSearch Id
   *
   * <p>Available UserSearch options are:.
   * <ul>
   *    <li>Id</li>
   * </ul>
   */
  private UserSearch driverSearch;

  /**
   * Search for DVIRLogs that were recorded at this date or after.
   */
  private LocalDateTime fromDate;

  /**
   * Search for DVIRLogs that were recorded at this date or before.
   */
  private LocalDateTime toDate;

  @Builder
  public MediaFileSearch(String id, DeviceSearch deviceSearch,
      UserSearch driverSearch, LocalDateTime fromDate, LocalDateTime toDate) {
    super(id);
    this.deviceSearch = deviceSearch;
    this.driverSearch = driverSearch;
    this.fromDate = fromDate;
    this.toDate = toDate;
  }
}
