/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.customproperty.Property;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The search criteria for {@link Property}.
 */
@Data
@NoArgsConstructor
public class PropertySearch extends IdSearch {

  /**
   * Search for Properties with this External Reference. Wildcard can be used by prepending/appending "%" to string.
   * Example "%externalreference%".
   */
  private String externalReference;

  /**
   * Search for Properties with this Name. Wildcard can be used by prepending/appending "%" to string. Example
   * "%name%".
   */
  private String name;

  @Builder
  public PropertySearch(String id, String externalReference, String name) {
    super(id);
    this.externalReference = externalReference;
    this.name = name;
  }
}
