/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.customproperty.PropertySet;
import java.util.List;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The search criteria for {@link PropertySet}.
 */
@Data
@NoArgsConstructor
public class PropertySetSearch extends IdSearch {

  /**
   * Search for PropertySets with this External Reference. Wildcard can be used by prepending/appending "%" to string.
   * Example "%externalreference%".
   */
  private String externalReference;

  /**
   * Search for PropertySets with this Name. Wildcard can be used by prepending/appending "%" to string. Example
   * "%name%".
   */
  private String name;

  /**
   * Search for PropertySets that are members of these {@link GroupSearch}(s) one of it's children or one of it's
   * parents.
   *
   * <p>Available GroupSearch options are:
   * <ul>
   *    <li>id</li>
   * </ul>
   */
  private List<GroupSearch> groups;

  @Builder
  public PropertySetSearch(String id, String externalReference, String name, List<GroupSearch> groups) {
    super(id);
    this.externalReference = externalReference;
    this.name = name;
    this.groups = groups;
  }
}
