/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.reporttemplate.ReportDataSource;
import com.geotab.model.entity.reporttemplate.ReportTemplate;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link ReportTemplate}(s).
 */
@Data
@NoArgsConstructor
public class ReportTemplateSearch extends IdSearch {

  /**
   * Include report Binary Data for this {@link ReportTemplate}.
   */
  private Boolean includeBinaryData;

  /**
   * Search for a {@link ReportTemplate} with this {@link ReportDataSource}.
   */
  private ReportDataSource reportDataSource;

  @Builder
  public ReportTemplateSearch(String id, Boolean includeBinaryData,
      ReportDataSource reportDataSource) {
    super(id);
    this.includeBinaryData = includeBinaryData;
    this.reportDataSource = reportDataSource;
  }
}
