/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.rule.ExceptionRuleBaseType;
import com.geotab.model.entity.rule.ExceptionRuleCategory;
import com.geotab.model.entity.rule.Rule;
import java.util.List;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for a {@link Rule}.
 */
@Data
@NoArgsConstructor
public class RuleSearch extends IdSearch {

  /**
   * Search for Rules that are members of these {@link GroupSearch}(s) one of it's children or one of it's parents.
   *
   * <p>Available GroupSearch options are:.
   * <ul>
   *    <li>id</li>
   * </ul>
   */
  private List<GroupSearch> groups;

  /**
   * Search for Rules with this Name. Wildcard can be used by prepending/appending "%" to string. Example "%comments%".
   */
  private String name;

  /**
   * Search for Rules that are this {@link ExceptionRuleBaseType}; either Custom, Stock, or ZoneStop.
   */
  private ExceptionRuleBaseType baseType;

  /**
   * Search for Rules that are in this {@link ExceptionRuleCategory}; either ApplicationExceptionRule,
   * UserExceptionRules or ZoneStopExceptionRules.
   */
  private ExceptionRuleCategory category;

  @Builder
  public RuleSearch(String id, List<GroupSearch> groups, String name,
      ExceptionRuleBaseType baseType, ExceptionRuleCategory category) {
    super(id);
    this.groups = groups;
    this.name = name;
    this.baseType = baseType;
    this.category = category;
  }
}
