package com.geotab.model.search;

import com.geotab.model.entity.tachograph.companycards.TachographCompanyCard;
import java.time.LocalDateTime;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link TachographCompanyCard}.
 */
@Data
@NoArgsConstructor
public class TachographCompanyCardSearch extends IdSearch {
  /**
   * Gets or sets search for tachograph company cards with this icc.
   */
  public Long icc;

  /**
   * Gets or sets search for tachograph company cards that match the card number.
   */
  public String cardNumber;

  /**
   * Gets or sets search for tachograph company cards that match this status.
   * The available values are:
   * <list>
   * <item>
   * <description>"Available": Company card available.</description>
   * </item>
   * <item>
   * <description>"Busy": Company card authenticating.</description>
   * </item>
   * <item>
   * <description>"Offline": Company card disconnected.</description>
   * </item>
   * </list>
   */
  public String status;

  /**
   * Gets or sets search for tachograph company cards
   * where the company card is valid at this time, and it is not expired.
   */
  public LocalDateTime isValidAt;

  @Builder
  public TachographCompanyCardSearch(String id, Long icc, String cardNumber, String status, LocalDateTime isValidAt) {
    super(id);
    this.icc = icc;
    this.cardNumber = cardNumber;
    this.status = status;
    this.isValidAt = isValidAt;
  }
}
