/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.entity.textmessage.MessageContentType;
import com.geotab.model.entity.textmessage.TextMessage;
import com.geotab.model.serialization.IdAsStringSerializer;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for a {@link TextMessage}.
 */
@Data
@NoArgsConstructor
public class TextMessageSearch extends IdSearch {

  /**
   * Gets or sets search for TextMessages sent to or received from this {@link DeviceSearch}.
   *
   * <p>Available DeviceSearch options are:
   *  <ul>
   *     <li>
   *         {@link Id}
   *     </li>
   * </ul>
   */
  private DeviceSearch deviceSearch;

  /**
   * Gets or sets search for TextMessages that were delivered/sent/read since this date.
   */
  private LocalDateTime modifiedSinceDate;

  /**
   * Gets or sets search for TextMessages that were sent at this date or before.
   */
  private LocalDateTime toDate;

  /**
   * Gets or sets search for TextMessages that have parent id as this id.
   *
   * <p>ParentTextMessageId is obsolete and will be removed. Please use ParentMessageId search
   * property.
   */
  private Long parentTextMessageId;

  /**
   * Gets or sets search for TextMessages that have parent id as this Id.
   */
  @JsonSerialize(using = IdAsStringSerializer.class)
  private Id parentMessageId;

  /**
   * Gets or sets search for TextMessages filtered based on the {@link MessageContentType}.
   */
  private List<MessageContentType> contentTypes;

  @Builder
  public TextMessageSearch(String id, DeviceSearch deviceSearch, LocalDateTime modifiedSinceDate,
      LocalDateTime toDate, Long parentTextMessageId, Id parentMessageId,
      List<MessageContentType> contentTypes) {
    super(id);
    this.deviceSearch = deviceSearch;
    this.modifiedSinceDate = modifiedSinceDate;
    this.toDate = toDate;
    this.parentTextMessageId = parentTextMessageId;
    this.parentMessageId = parentMessageId;
    this.contentTypes = contentTypes;
  }
}
