/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.trailer.Trailer;
import java.util.List;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link Trailer}(s).
 */
@Data
@NoArgsConstructor
public class TrailerSearch extends IdSearch {

  /**
   * Search for Trailers with a name containing this String. Wildcard can be used by prepending/appending "%" to
   * string.
   */
  private String name;

  /**
   * Search for Trailers that are members of these {@link GroupSearch}(s) one of it's children or one of it's parents.
   *
   * <p>Available GroupSearch options are:
   * <ul>
   *      <li>
   *             GroupSearch.id
   *     </li>
   * </ul>
   *
   * <p>Cannot be used with CompanyGroups.
   */
  private List<GroupSearch> groups;

  @Builder
  public TrailerSearch(String id, String name, List<GroupSearch> groups) {
    super(id);
    this.name = name;
    this.groups = groups;
  }
}
