/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.workholiday.WorkHoliday;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for a {@link WorkHoliday}.
 */
@Data
@NoArgsConstructor
public class WorkHolidaySearch extends IdSearch {

  /**
   * Search for {@link WorkHoliday}s with this Name. Wildcard can be used by prepending/appending "%" to string. Example
   * "%name%".
   */
  private String name;

  @Builder
  public WorkHolidaySearch(String id, String name) {
    super(id);
    this.name = name;
  }
}
