/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class WorkTimeSearch extends IdSearch {

  /**
   * Search for WorkTimes with this Name. Wildcard can be used by prepending/appending "%" to string. Example "%name%".
   */
  private String name;

  @Builder
  public WorkTimeSearch(String id, String name) {
    super(id);
    this.name = name;
  }
}
