/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.geotab.model.entity.failuremode.FailureMode;

public class ApiCustomSerializerModifier extends BeanSerializerModifier {

  @Override
  public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc,
      JsonSerializer<?> serializer) {
    if (FailureMode.class.isAssignableFrom(beanDesc.getBeanClass())) {
      return new FailureModeSerializer((JsonSerializer<Object>) serializer);
    }

    return serializer;
  }
}