/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Base64;

public class ByteArraySerializer extends JsonSerializer<Byte[]> {

  @Override
  public void serialize(Byte[] bytes, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {

    if (bytes != null) {
      final byte[] result = new byte[bytes.length];
      for (int i = 0; i < bytes.length; i++) {
        result[i] = bytes[i];
      }
      String encodedBytes = new String(Base64.getEncoder().encode(result));
      jsonGenerator.writeString(encodedBytes);
    }
  }
}
