/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.geotab.model.entity.Entity;
import java.io.IOException;

public class EntityAsIdSerializer extends JsonSerializer<Entity> {

  @Override
  public void serialize(Entity v, JsonGenerator jg, SerializerProvider sp) throws IOException {
    if (v.isSystemEntity()) {
      jg.writeString(v.getId().getId());
    } else {
      jg.writeObject(v.getId());
    }
  }
}
