package com.geotab.model.serialization;

import com.fasterxml.jackson.databind.util.StdConverter;
import com.geotab.model.Id;
import com.geotab.model.entity.Entity;
import java.util.Collection;
import java.util.stream.Collectors;

public class EntityCollectionAsIdCollectionSerializer extends
    StdConverter<Collection<Entity>, Collection<Id>> {

  @Override
  public Collection<Id> convert(Collection<Entity> entities) {
    return entities.stream().map(Entity::getId).collect(Collectors.toList());
  }
}
