/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class FloatArraySerializer extends JsonSerializer<Float[]> {

  @Override
  public void serialize(Float[] floatArray, JsonGenerator jsonGenerator,
      SerializerProvider serializers) throws IOException {

    jsonGenerator.writeStartArray();

    for (Float number : floatArray) {
      ApiJsonSerializer.serializeNumberWithDecimals(number, jsonGenerator);
    }

    jsonGenerator.writeEndArray();
  }
}
