/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.Id;
import java.io.IOException;

public class IdDeserializer extends JsonDeserializer<Id> {

  @Override
  public Id deserialize(JsonParser jsonParser, DeserializationContext context)
      throws IOException {
    ObjectCodec parserCodec = jsonParser.getCodec();
    JsonNode node = parserCodec.readTree(jsonParser);

    if (node.isTextual()) {
      return new Id(node.textValue());
    } else if (node.isObject()) {
      return new Id(node.get("id").textValue());
    } else {
      return null;
    }
  }
}
