/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.databind.util.StdConverter;
import com.geotab.model.Id;
import java.util.List;
import java.util.stream.Collectors;

public class ListIdConverter extends StdConverter<List<Id>, List<String>> {

  @Override
  public List<String> convert(List<Id> users) {
    return users.stream().map(Id::getId).collect(Collectors.toList());
  }
}
