/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;

/**
 * Markup interface used to identify in a centralized manner the system entities for specific serialization.
 *
 * <p>Be aware that not all system entities will be serialized this way by default; so mark the
 * model only if appropriate.
 *
 * <p>For example {@link com.geotab.model.entity.group.SystemSecurityClearance}
 * and {@link com.geotab.model.entity.group.SystemGroupBase} will not implement this interface.
 *
 * <p>Check serialization details in {@link SystemEntitySerializer}.
 */
@JsonSerialize(using = SystemEntitySerializer.class)
public interface SystemEntitySerializationAware {

  /**
   * Returns true if the class is a system entity, false otherwise.
   *
   * @return true if the entity is a system entity; otherwise, false.
   */
  boolean isSystemEntity();

  /**
   * Get Entity id.
   *
   * @return The id of the entity.
   */
  Id getId();
}
