/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import static com.geotab.model.serialization.ApiCustomDeserializerModifier.defaultDeserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.textmessage.TextMessage;
import com.geotab.util.Util;
import java.io.IOException;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class TextMessageDeserializer extends JsonDeserializer<TextMessage> {

  @Override
  public TextMessage deserialize(JsonParser jsonParser, DeserializationContext context)
      throws IOException {
    ObjectCodec parserCodec = jsonParser.getCodec();
    JsonNode node = parserCodec.readTree(jsonParser);

    if (node.isTextual()) {
      String textMessageId = node.textValue();
      TextMessage textMessage = null;
      if (Util.isNotEmpty(textMessageId)) {
        textMessage = TextMessage.builder()
            .id(textMessageId)
            .build();
      } else {
        log.warn("Unknown text message with empty id {}.", textMessageId);
      }
      return textMessage;
    } else if (node.isObject()) {
      return defaultDeserialize(parserCodec, context, node, TextMessage.class);
    }

    return null;
  }
}
