/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureNone.UNIT_OF_MEASURE_NONE_ID;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.geotab.model.entity.unitofmeasure.UnitOfMeasure;
import java.io.IOException;

public class UnitOfMeasureSerializer extends JsonSerializer<UnitOfMeasure> {

  @Override
  public void serialize(UnitOfMeasure o, JsonGenerator jg, SerializerProvider sp) throws IOException {
    if (o.isSystemEntity()) {
      jg.writeString(o.getId().getId());
    } else {
      jg.writeString(UNIT_OF_MEASURE_NONE_ID);
    }
  }
}
