/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import static com.geotab.model.serialization.ApiCustomDeserializerModifier.defaultDeserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.user.Driver;
import com.geotab.model.entity.user.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;

public class UserDeserializer extends JsonDeserializer<User> {

  @Override
  public User deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
    ObjectCodec parserCodec = jsonParser.getCodec();
    JsonNode node = parserCodec.readTree(jsonParser);
    if (node.isTextual()) return User.fromSystem(node.asText());
    User system = User.fromSystem(Optional.ofNullable(node.get("id")).map(JsonNode::textValue).orElse(""));
    if (system != null) return system;
    Class<? extends User> userType = isDriver(node, parserCodec) ? Driver.class : User.class;
    return defaultDeserialize(parserCodec, context, node, userType);
  }

  private boolean isDriver(JsonNode node, ObjectCodec parserCodec) throws JsonProcessingException {
    if (node.get("isDriver") != null && node.get("isDriver").asBoolean()) return true;
    return parserCodec.treeToValue(node.get("driverGroups"), ArrayList.class) != null;
  }
}
