/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization.filter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.geotab.model.entity.controller.Controller;
import com.geotab.model.entity.controller.NoController;
import com.geotab.model.entity.faultdata.FaultData;
import com.geotab.model.entity.user.NoUser;
import com.geotab.model.entity.user.User;

/**
 * Custom {@link FaultData} serialization filter based on properties values.
 */
public class FaultDataFilterProvider extends SimpleBeanPropertyFilter {

  public static final String FAULT_DATA_FILTER = "FAULT_DATA_FILTER";

  @Override
  public void serializeAsField(Object v, JsonGenerator jg, SerializerProvider sp, PropertyWriter pw) throws Exception {
    if (v != null && FaultData.class.isAssignableFrom(v.getClass())) {
      if (include(pw)) {
        if (!"controller".equals(pw.getName()) && !"dismissUser".equals(pw.getName())) {
          pw.serializeAsField(v, jg, sp);
          return;
        }

        if ("controller".equals(pw.getName())) {
          Controller controller = ((FaultData) v).getController();
          if (!NoController.getInstance().equals(controller)) {
            pw.serializeAsField(v, jg, sp);
          }
        }

        if ("dismissUser".equals(pw.getName())) {
          User user = ((FaultData) v).getDismissUser();
          if (!NoUser.getInstance().equals(user)) {
            pw.serializeAsField(v, jg, sp);
          }
        }
      } else if (!jg.canOmitFields()) { // since 2.3
        pw.serializeAsOmittedField(v, jg, sp);
      }
    }
  }

  @Override
  protected boolean include(BeanPropertyWriter writer) {
    return true;
  }

  @Override
  protected boolean include(PropertyWriter writer) {
    return true;
  }
}
