/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.settings;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.geotab.model.entity.fuel.FuelEconomyUnit;
import com.geotab.model.entity.user.ElectricEnergyEconomyUnit;
import com.geotab.model.entity.user.ZoneDisplayMode;
import com.geotab.model.entity.worktime.DayOfWeek;
import java.time.LocalDateTime;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Settings that apply to client application.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@SuppressWarnings("AbbreviationAsWordInName")
public class ClientSettings {

  /**
   * The default TimeZone.
   */
  public static final String DEFAULT_TIMEZONE = "America/New_York";

  /**
   * A value indicating accepted EULA revision.
   */
  private Integer acceptedEULA;

  /**
   * The accepted EULA date.
   */
  private LocalDateTime acceptedEULADate;

  /**
   * The active dashboard reports.
   */
  private List<String> activeDashboardReports;

  /**
   * The available dashboard reports.
   */
  private List<String> availableDashboardReports;

  /**
   * The map views.
   */
  private List<MapView> mapViews;

  /**
   * Allow HOS yard move exemption.
   */
  @JsonProperty("isYardMoveEnabled")
  private boolean isYardMoveEnabled;

  /**
   * Allow HOS personal conveyance exemption.
   */
  @JsonProperty("isPersonalConveyanceEnabled")
  private boolean isPersonalConveyanceEnabled;

  /**
   * Allow Custom Exempt HOS Exemption.
   */
  @JsonProperty("isExemptHOSEnabled")
  private boolean isExemptHOSEnabled;

  /**
   * The user time zone identifier.
   */
  private String userTimeZoneId;

  /**
   * The allowed responses to a GPSTextMessage.
   */
  private String[][] cannedResponseOptions;

  /**
   * Whether the password requires resetting.
   */
  @JsonProperty("changePassword")
  private boolean changePassword;

  /**
   * The date format.
   */
  private String dateFormat;

  /**
   * The user phone number.
   */
  private String phoneNumber;

  /**
   * The user country code.
   */
  private String countryCode;

  /**
   * The phone number extension.
   */
  private String phoneNumberExtension;

  /**
   * The default map style for Google maps.
   */
  private GoogleMapStyle defaultGoogleMapStyle;

  /**
   * The default map engine.
   */
  private String defaultMapEngine;

  /**
   * The default map style for open street maps.
   */
  private OpenStreetMapStyle defaultOpenStreetMapStyle;

  /**
   * The default map style for Here maps.
   */
  private HereMapStyle defaultHereMapStyle;

  /**
   * Indicates the default page to view when login complete.
   */
  private String defaultPage;

  /**
   * Fuel Economy Unit.
   */
  private FuelEconomyUnit fuelEconomyUnit;

  /**
   * Electric Energy Economy Unit.
   */
  private ElectricEnergyEconomyUnit electricEnergyEconomyUnit;

  /**
   * Value indicating whether are labs enabled for this user. When [true] this will enable experimental features that
   * aren't quite ready for production.
   */
  @JsonProperty("isLabsEnabled")
  private boolean isLabsEnabled;

  /**
   * Value indicating whether are news notifications enabled for this user.
   */
  @JsonProperty("isNewsEnabled")
  private boolean isNewsEnabled;

  /**
   * Value indicating whether are service update notifications enabled for this user.
   */
  @JsonProperty("isServiceUpdatesEnabled")
  private boolean isServiceUpdatesEnabled;

  /**
   * Value indicating whether gets a value indicating whether the current regional settings is in Metric.
   */
  @JsonProperty("isMetric")
  private boolean isMetric;

  /**
   * The user's language.
   */
  private String language;

  /**
   * A value indicating whether to show ClickOnce support warning as the default page.
   */
  @JsonProperty("showClickOnceWarning")
  private boolean showClickOnceWarning;

  /**
   * The zone display mode.
   */
  private ZoneDisplayMode zoneDisplayMode;

  /**
   * The first day of the calendar week.
   */
  private DayOfWeek firstDayOfWeek;

  /**
   * The name of the company.
   */
  private String companyName;

  /**
   * The company address.
   */
  private String companyAddress;

  /**
   * The carrier number.
   */
  private String carrierNumber;

  /**
   * Value indicating the maximum personal conveyance limit per day.
   */
  private Double maxPCDistancePerDay;

  /**
   * The name of the authority.
   */
  private String authorityName;

  /**
   * The authority address.
   */
  private String authorityAddress;

  /**
   * The version of the last drive what's new guide viewed by the user.
   */
  private Integer driveGuideVersion;

  /**
   * Value indicating accepted WiFi-specific EULA version.
   */
  private Integer wifiEULA;
}
