/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.settings;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum GoogleMapStyle implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown"),

  /**
   * Google map road map view.
   */
  ROADMAP("Roadmap"),

  /**
   * Google map hybrid view.
   */
  HYBRID("Hybrid"),

  /**
   * Google map terrain view.
   */
  TERRAIN("Terrain"),

  /**
   * Google map satellite view.
   */
  SATELLITE("Satellite");

  private final String name;

  GoogleMapStyle(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
