/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.settings;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum HereMapStyle implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown"),

  /**
   * No map style.
   */
  NONE("None"),

  /**
   * The road map style.
   */
  ROADMAP("Roadmap"),

  /**
   * The map satellite style.
   */
  SATELLITE("Satellite"),

  /**
   * The map terrain style.
   */
  TERRAIN("Terrain");

  private final String name;

  HereMapStyle(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
