/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.settings;

import com.geotab.model.drawing.RectangleF;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * A Map View with a name and a viewport.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class MapView {

  /**
   * Name search for a map view.
   */
  private String name;

  /**
   * The highlighted groups on the map.
   */
  private List<String> highlightGroups;

  /**
   * The view port rectangle boundary of the map view.
   */
  private RectangleF viewport;

  @Override
  public String toString() {
    return "MapView{name='" + name + "'}";
  }
}
