/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.util;

import lombok.experimental.UtilityClass;

@UtilityClass
public class LogRecordValidator {

  /**
   * Determines if a coordinate is outside of the allowed latitude, longitude values range.
   *
   * @param longitude The longitude.
   * @param latitude  The latitude.
   * @return True if it is valid
   */
  public static boolean isValidCoordinateRange(double longitude, double latitude) {
    return longitude > -180
        && longitude < 180
        && latitude > -90
        && latitude < 90
        && (longitude != 0f || latitude != 0f);
  }
}
