/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.geotab.api.Api;
import com.geotab.api.WebMethods;
import com.geotab.http.exception.InvalidUserException;
import com.geotab.http.invoker.ServerInvoker;
import com.geotab.http.request.AuthenticatedRequest;
import com.geotab.http.request.BaseRequest;
import com.geotab.http.request.MultiCallRequest;
import com.geotab.http.request.param.AuthenticateParameters;
import com.geotab.http.request.param.AuthenticatedParameters;
import com.geotab.http.request.param.MultiCallParameters;
import com.geotab.http.response.BaseResponse;
import com.geotab.model.FeedResult;
import com.geotab.model.Id;
import com.geotab.model.entity.Entity;
import com.geotab.model.login.Credentials;
import com.geotab.model.login.LoginResult;
import com.geotab.model.serialization.ApiJsonSerializer;
import com.geotab.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeotabApi
implements Api {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeotabApi.class);
    public static final String THIS_SERVER = "ThisServer";
    public static final String DEFAULT_SERVER = "my.geotab.com";
    public static final String PROTOCOL = "https://";
    protected final Credentials credentials;
    protected final String server;
    protected final int timeout;
    protected final AtomicReference<LoginResult> auth = new AtomicReference();
    protected final AtomicReference<ServerInvoker> invoker = new AtomicReference();

    public GeotabApi(Credentials credentials) {
        this(credentials, DEFAULT_SERVER, 300000);
    }

    public GeotabApi(Credentials credentials, String server, int timeout) {
        this(credentials, server, timeout, null, null);
    }

    public GeotabApi(Credentials credentials, String server, int timeout, String servicePath, CloseableHttpClient httpClient) {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials not provided");
        }
        log.debug("API params: credentials = {},  server = {}, timeout = {}, servicePath = {}, {}", new Object[]{credentials, server, timeout, servicePath, httpClient != null ? "custom http client" : "default http client"});
        credentials.validate();
        this.credentials = credentials;
        this.timeout = timeout;
        this.server = Optional.ofNullable(server).orElse(DEFAULT_SERVER);
        this.invoker.set(this.buildServerInvoker(PROTOCOL + this.server, this.timeout, servicePath, httpClient));
    }

    private ObjectMapper om() {
        return ApiJsonSerializer.getInstance().getObjectMapper();
    }

    private TypeFactory tf() {
        return this.om().getTypeFactory();
    }

    @Override
    public boolean isAuthenticated() {
        LoginResult loginResult = this.auth.get();
        return loginResult != null && loginResult.getCredentials() != null;
    }

    @Override
    public LoginResult authenticate() {
        LoginResult loginResult;
        if (this.isAuthenticated()) {
            return this.auth.get();
        }
        if (Util.isNotEmpty(this.credentials.getSessionId())) {
            log.debug("Geotab session id is provided as part of the credentials; will not call Geotab Authenticate method");
            loginResult = LoginResult.builder().path(this.server).credentials((Credentials)((Credentials.CredentialsBuilder)((Credentials.CredentialsBuilder)((Credentials.CredentialsBuilder)Credentials.builder().database(this.credentials.getDatabase())).userName(this.credentials.getUserName())).sessionId(this.credentials.getSessionId())).build()).build();
            this.auth.set(loginResult);
        } else {
            log.debug("Calling Geotab Authenticate method ...");
            AuthenticatedRequest<AuthenticatedParameters> req = this.prepareMethod(WebMethods.Authenticate, ((AuthenticateParameters.AuthenticateParametersBuilder)((AuthenticateParameters.AuthenticateParametersBuilder)((AuthenticateParameters.AuthenticateParametersBuilder)AuthenticateParameters.builder().database(this.credentials.getDatabase())).userName(this.credentials.getUserName())).password(this.credentials.getPassword())).build());
            loginResult = this.invoker.get().invoke(req, WebMethods.Authenticate).orElse(null);
            this.auth.set(loginResult);
            log.info("Geotab Authenticate is successful");
        }
        if (!THIS_SERVER.equals(this.auth.get().getPath())) {
            this.invoker.get().setUrl(this.buildServerPath());
        }
        return loginResult;
    }

    @Override
    public <O extends BaseResponse<T>, T> Optional<T> call(AuthenticatedRequest<?> in, Class<O> outT) {
        if (in == null) {
            throw new IllegalArgumentException("Request expected");
        }
        if (outT == null) {
            throw new IllegalArgumentException("Response type must be provided");
        }
        return this.doCall(in, () -> this.invoker.get().invoke(in, outT));
    }

    @Override
    public <T> Optional<T> callResult(AuthenticatedRequest<?> in, Class<T> outT) {
        if (in == null) {
            throw new IllegalArgumentException("Request expected");
        }
        if (outT == null) {
            throw new IllegalArgumentException("Response type must be provided");
        }
        JavaType responseT = this.tf().constructParametricType(BaseResponse.class, new Class[]{outT});
        return this.doCall(in, () -> this.invoker.get().invokeUnsafe(in, responseT));
    }

    @Override
    public <P extends AuthenticatedParameters, R> Optional<R> callMethod(Api.MethodDescriptor<P, R> method, P params) {
        AuthenticatedRequest in = this.prepareMethod(method, params);
        JavaType responseT = this.tf().constructParametricType(BaseResponse.class, new JavaType[]{method.resultType()});
        return this.doCall(in, () -> this.invoker.get().invokeUnsafe(in, responseT));
    }

    private <P extends AuthenticatedParameters, R> AuthenticatedRequest<P> prepareMethod(Api.MethodDescriptor<P, R> method, P params) {
        if (method == null) {
            throw new IllegalArgumentException("Method expected");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters expected");
        }
        return ((AuthenticatedRequest.AuthenticatedRequestBuilder)((AuthenticatedRequest.AuthenticatedRequestBuilder)AuthenticatedRequest.authRequestBuilder().method(method.name)).params(params)).build();
    }

    @Override
    public <T> Optional<List<T>> callResultList(AuthenticatedRequest<?> in, Class<T> outT) {
        if (in == null) {
            throw new IllegalArgumentException("Request expected");
        }
        if (outT == null) {
            throw new IllegalArgumentException("Response type must be provided");
        }
        CollectionType resultT = this.tf().constructCollectionType(List.class, outT);
        JavaType responseT = this.tf().constructParametricType(BaseResponse.class, new JavaType[]{resultT});
        return this.doCall(in, () -> this.invoker.get().invokeUnsafe(in, responseT));
    }

    @Override
    public Optional<Id> callAdd(AuthenticatedRequest<?> in) {
        JavaType responseT = this.tf().constructParametricType(BaseResponse.class, new JavaType[]{this.prepareAdd(in)});
        return this.doCall(in, () -> this.invoker.get().invokeUnsafe(in, responseT));
    }

    private JavaType prepareAdd(AuthenticatedRequest<?> in) {
        if (in == null) {
            throw new IllegalArgumentException("Request expected");
        }
        if (!"Add".equals(in.getMethod())) {
            throw new IllegalArgumentException("Request method 'Add' expected");
        }
        return this.tf().constructType(Id.class);
    }

    @Override
    public <T extends Entity> Optional<List<T>> callGet(AuthenticatedRequest<?> in, Class<T> outT) {
        JavaType responseT = this.tf().constructParametricType(BaseResponse.class, new JavaType[]{this.prepareGet(in, outT)});
        return this.doCall(in, () -> this.invoker.get().invokeUnsafe(in, responseT));
    }

    private <T extends Entity> JavaType prepareGet(AuthenticatedRequest<?> in, Class<T> outT) {
        if (in == null) {
            throw new IllegalArgumentException("Request expected");
        }
        if (!"Get".equals(in.getMethod())) {
            throw new IllegalArgumentException("Request method 'Get' expected");
        }
        if (outT == null) {
            throw new IllegalArgumentException("Response type must be provided");
        }
        return this.tf().constructCollectionType(List.class, outT);
    }

    @Override
    public Optional<Integer> callGetCountOf(AuthenticatedRequest<?> in) {
        JavaType responseT = this.tf().constructParametricType(BaseResponse.class, new JavaType[]{this.prepareGetCountOf(in)});
        return this.doCall(in, () -> this.invoker.get().invokeUnsafe(in, responseT));
    }

    private JavaType prepareGetCountOf(AuthenticatedRequest<?> in) {
        if (in == null) {
            throw new IllegalArgumentException("Request expected");
        }
        if (!"GetCountOf".equals(in.getMethod())) {
            throw new IllegalArgumentException("Request method 'GetCountOf' expected");
        }
        return this.tf().constructType(Integer.class);
    }

    @Override
    public <T extends Entity> Optional<FeedResult<T>> callGetFeed(AuthenticatedRequest<?> in, Class<T> outT) {
        JavaType responseT = this.tf().constructParametricType(BaseResponse.class, new JavaType[]{this.prepareGetFeed(in, outT)});
        return this.doCall(in, () -> this.invoker.get().invokeUnsafe(in, responseT));
    }

    private <T extends Entity> JavaType prepareGetFeed(AuthenticatedRequest<?> in, Class<T> outT) {
        if (in == null) {
            throw new IllegalArgumentException("Request expected");
        }
        if (!"GetFeed".equals(in.getMethod())) {
            throw new IllegalArgumentException("Request method 'GetFeed' expected");
        }
        if (outT == null) {
            throw new IllegalArgumentException("Response type must be provided");
        }
        return this.tf().constructParametricType(FeedResult.class, new Class[]{outT});
    }

    @Override
    public void callSet(AuthenticatedRequest<?> in) {
        JavaType responseT = this.tf().constructParametricType(BaseResponse.class, new JavaType[]{this.prepareSet(in)});
        this.doCall(in, () -> this.invoker.get().invokeUnsafe(in, responseT));
    }

    private JavaType prepareSet(AuthenticatedRequest<?> in) {
        if (in == null) {
            throw new IllegalArgumentException("Request expected");
        }
        if (!"Set".equals(in.getMethod())) {
            throw new IllegalArgumentException("Request method 'Set' expected");
        }
        return this.tf().constructType(Void.class);
    }

    @Override
    public void callRemove(AuthenticatedRequest<?> in) {
        JavaType responseT = this.tf().constructParametricType(BaseResponse.class, new JavaType[]{this.prepareRemove(in)});
        this.doCall(in, () -> this.invoker.get().invokeUnsafe(in, responseT));
    }

    private JavaType prepareRemove(AuthenticatedRequest<?> in) {
        if (in == null) {
            throw new IllegalArgumentException("Request expected");
        }
        if (!"Remove".equals(in.getMethod())) {
            throw new IllegalArgumentException("Request method 'Remove' expected");
        }
        return this.tf().constructType(Void.class);
    }

    private <T> Optional<T> doCall(AuthenticatedRequest<?> in, Supplier<Optional<T>> supplier) {
        if (in == null) {
            throw new IllegalArgumentException("Request expected");
        }
        if (in.getMethod() == null) {
            throw new IllegalArgumentException("Request method must be provided");
        }
        boolean retry = false;
        while (true) {
            if (!(in.getCredentials().isPresent() && !retry || this.isAuthenticated())) {
                this.authenticate();
            }
            if (!in.getCredentials().isPresent()) {
                LoginResult loginResult = this.auth.get();
                in.setCredentials(loginResult.getCredentials());
            }
            try {
                return supplier.get();
            }
            catch (InvalidUserException ex) {
                in.setCredentials(null);
                this.auth.set(null);
                if (retry || Util.isEmpty(this.credentials.getPassword())) {
                    log.error("Geotab call failed due to authentication; trying to re-authenticate also failed.", (Throwable)ex);
                    throw ex;
                }
                log.warn("Geotab call failed due to authentication; trying to re-authenticate and re-call");
                retry = true;
                continue;
            }
            break;
        }
    }

    @Override
    public <O extends BaseResponse<T>, T> Optional<T> multiCall(MultiCallRequest in, Class<O> outT) {
        return this.call(in, outT);
    }

    @Override
    public <T> Optional<List<T>> uniformMultiCall(List<? extends BaseRequest<?>> calls, Class<T> outT) {
        if (outT == null) {
            throw new IllegalArgumentException("Response type must be provided");
        }
        AuthenticatedRequest request = ((MultiCallRequest.MultiCallRequestBuilder)MultiCallRequest.multiCallRequestBuilder().params(((MultiCallParameters.MultiCallParametersBuilder)MultiCallParameters.multiCallParamsBuilder().calls(Collections.unmodifiableList(calls))).build())).build();
        return this.doCall(request, () -> this.lambda$uniformMultiCall$11((MultiCallRequest)request, outT));
    }

    @Override
    public Api.MultiCallBuilder buildMultiCall() {
        return new Api.MultiCallBuilder(){
            final List<MyCall<?>> calls = new ArrayList();
            Map<String, Object> httpHeaders;

            <T> MyCall<T> add(AuthenticatedRequest<?> in, JavaType outT) {
                MyCall call = new MyCall(in, outT);
                this.calls.add(call);
                return call;
            }

            @Override
            public Api.MultiCallBuilder httpHeaders(Map<String, Object> httpHeaders) {
                this.httpHeaders = httpHeaders;
                return this;
            }

            @Override
            public <O extends BaseResponse<T>, T> Supplier<T> call(AuthenticatedRequest<?> in, Class<O> outT) {
                JavaType asBaseResponse = GeotabApi.this.tf().constructType(outT).findSuperType(BaseResponse.class);
                if (asBaseResponse == null) {
                    throw new IllegalArgumentException("subtype of BaseResponse expected");
                }
                return this.add(in, asBaseResponse.containedType(0));
            }

            @Override
            public <T> Supplier<T> callResult(AuthenticatedRequest<?> in, Class<T> outT) {
                if (in == null) {
                    throw new IllegalArgumentException("Request expected");
                }
                if (outT == null) {
                    throw new IllegalArgumentException("Response type must be provided");
                }
                return this.add(in, GeotabApi.this.tf().constructType(outT));
            }

            @Override
            public <T> Supplier<List<T>> callResultList(AuthenticatedRequest<?> in, Class<T> outT) {
                if (in == null) {
                    throw new IllegalArgumentException("Request expected");
                }
                if (outT == null) {
                    throw new IllegalArgumentException("Response type must be provided");
                }
                return this.add(in, (JavaType)GeotabApi.this.tf().constructCollectionType(List.class, outT));
            }

            @Override
            public <P extends AuthenticatedParameters, R> Supplier<R> callMethod(Api.MethodDescriptor<P, R> in, P params) {
                return this.add(GeotabApi.this.prepareMethod(in, params), in.resultType());
            }

            @Override
            public Supplier<Id> callAdd(AuthenticatedRequest<?> in) {
                return this.add(in, GeotabApi.this.prepareAdd(in));
            }

            @Override
            public <T extends Entity> Supplier<List<T>> callGet(AuthenticatedRequest<?> in, Class<T> outT) {
                return this.add(in, GeotabApi.this.prepareGet(in, outT));
            }

            @Override
            public Supplier<Integer> callGetCountOf(AuthenticatedRequest<?> in) {
                return this.add(in, GeotabApi.this.prepareGetCountOf(in));
            }

            @Override
            public <T extends Entity> Supplier<FeedResult<T>> callGetFeed(AuthenticatedRequest<?> in, Class<T> outT) {
                return this.add(in, GeotabApi.this.prepareGetFeed(in, outT));
            }

            @Override
            public void callSet(AuthenticatedRequest<?> in) {
                this.add(in, GeotabApi.this.prepareSet(in));
            }

            @Override
            public void callRemove(AuthenticatedRequest<?> in) {
                this.add(in, GeotabApi.this.prepareRemove(in));
            }

            @Override
            public void execute() {
                ArrayList requests = new ArrayList(this.calls.size());
                for (MyCall<?> call : this.calls) {
                    requests.add(((MyCall)call).in);
                }
                AuthenticatedRequest request = ((MultiCallRequest.MultiCallRequestBuilder)((MultiCallRequest.MultiCallRequestBuilder)MultiCallRequest.multiCallRequestBuilder().params(((MultiCallParameters.MultiCallParametersBuilder)MultiCallParameters.multiCallParamsBuilder().calls(requests)).build())).httpHeaders(this.httpHeaders)).build();
                GeotabApi.this.doCall(request, () -> this.lambda$execute$1((MultiCallRequest)request));
            }

            private /* synthetic */ Optional lambda$execute$1(MultiCallRequest request) {
                return GeotabApi.this.invoker.get().invokeJson(request).map(multiCallResult -> {
                    ObjectMapper om = GeotabApi.this.om();
                    try {
                        if (!multiCallResult.isArray()) {
                            throw new RuntimeException("Invalid response, cause: multiCall expect array result");
                        }
                        if (multiCallResult.size() != this.calls.size()) {
                            throw new RuntimeException("Invalid response, cause: multiCall array size mismatch");
                        }
                        for (int i = 0; i < this.calls.size(); ++i) {
                            ((MyCall)this.calls.get(i)).resolve(om, multiCallResult.get(i));
                        }
                        return null;
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException("Invalid response, cause: decoding JSON error", e);
                    }
                });
            }

            class MyCall<T>
            implements Supplier<T> {
                private final AuthenticatedRequest<?> in;
                private final JavaType outT;
                private boolean executed = false;
                private T out;

                MyCall(AuthenticatedRequest<?> in, JavaType outT) {
                    this.in = in;
                    this.outT = outT;
                }

                @Override
                public T get() {
                    if (!this.executed) {
                        throw new IllegalStateException("Multi-call builder not executed");
                    }
                    return this.out;
                }

                private void resolve(ObjectMapper om, JsonNode node) throws JsonProcessingException {
                    this.out = om.treeToValue((TreeNode)node, this.outT);
                    this.executed = true;
                }
            }
        };
    }

    public void disconnect() {
        if (this.invoker.get() != null) {
            log.debug("Disconnecting API ...");
            this.invoker.get().disconnect();
        }
    }

    @Override
    public void close() {
        this.disconnect();
    }

    protected ServerInvoker buildServerInvoker(String url, Integer timeout, String servicePath, CloseableHttpClient httpClient) {
        return new ServerInvoker(url, timeout, servicePath, httpClient);
    }

    private String buildServerPath() {
        String newPath = PROTOCOL + this.auth.get().getPath();
        newPath = newPath.endsWith("/") ? newPath.substring(0, newPath.length() - 1) : newPath;
        return newPath;
    }

    private /* synthetic */ Optional lambda$uniformMultiCall$11(MultiCallRequest request, Class outT) {
        return this.invoker.get().invokeJson(request).map(multiCallResult -> {
            ObjectMapper om = this.om();
            try {
                if (!multiCallResult.isArray()) {
                    throw new RuntimeException("Invalid response, cause: multiCall expect array result");
                }
                ArrayList<Object> out = new ArrayList<Object>();
                for (JsonNode perCallResult : multiCallResult) {
                    Iterator iterator = (perCallResult.isArray() ? perCallResult : Collections.singleton(perCallResult)).iterator();
                    while (iterator.hasNext()) {
                        JsonNode typeResult = (JsonNode)iterator.next();
                        out.add(om.treeToValue((TreeNode)typeResult, outT));
                    }
                }
                return out;
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Invalid response, cause: decoding JSON error", e);
            }
        });
    }
}

