/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.coordinate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.geotab.model.serialization.CoordinateDeserializer;
import com.geotab.util.Util;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@JsonDeserialize(using=CoordinateDeserializer.class)
public class Coordinate {
    private double x;
    private double y;

    public static double distanceBetween(double x1, double y1, double x2, double y2) {
        x1 = x1 * Math.PI / 180.0;
        y1 = y1 * Math.PI / 180.0;
        x2 = x2 * Math.PI / 180.0;
        y2 = y2 * Math.PI / 180.0;
        double t1 = Math.sin((y2 - y1) / 2.0);
        double t2 = Math.sin((x2 - x1) / 2.0);
        double a = t1 * t1 + Math.cos(y1) * Math.cos(y2) * t2 * t2;
        double c = 2.0 * Math.asin(Math.min(1.0, Math.sqrt(a)));
        return 6367000.0 * c;
    }

    public static double distanceFromPoly(double x, double y, List<Coordinate> polygon) {
        double minDistance = Double.MAX_VALUE;
        int minIndex = -1;
        int count = polygon.size();
        if (count == 0) {
            return Double.MAX_VALUE;
        }
        for (int i = 0; i < count - 1; ++i) {
            Coordinate point = polygon.get(i);
            double distance = Coordinate.distanceBetween(point.x, point.y, x, y);
            if (!(distance < minDistance)) continue;
            minIndex = i;
            minDistance = distance;
        }
        minDistance = Coordinate.getDistanceToSegment(x, y, polygon, minIndex, minIndex - 1);
        double minDistance1 = Coordinate.getDistanceToSegment(x, y, polygon, minIndex, minIndex + 1);
        return Math.min(minDistance, minDistance1);
    }

    public static int getBearing(Coordinate from, Coordinate to) {
        double latFrom = from.y * 0.0174532925199433;
        double longFrom = from.x * 0.0174532925199433;
        double latTo = to.y * 0.0174532925199433;
        double longTo = to.x * 0.0174532925199433;
        double y = Math.sin(longTo - longFrom) * Math.cos(latTo);
        double x = Math.cos(latFrom) * Math.sin(latTo) - Math.sin(latFrom) * Math.cos(latTo) * Math.cos(longFrom - longTo);
        int num1 = 360 + (int)(Math.atan2(y, x) * 57.2957795130823);
        return num1 % 360;
    }

    public static List<Coordinate> getCalculatedExtent(List<Coordinate> features) {
        if (features == null) {
            return null;
        }
        int count = features.size();
        if (count == 0) {
            return null;
        }
        Coordinate point = features.get(0);
        double x = point.x;
        double y = point.y;
        double xMin = x;
        double yMin = y;
        double xMax = x;
        double yMax = y;
        for (int i = 1; i < count; ++i) {
            point = features.get(i);
            x = point.x;
            y = point.y;
            if (x <= xMin) {
                xMin = x;
            } else if (x >= xMax) {
                xMax = x;
            }
            if (y <= yMin) {
                yMin = y;
                continue;
            }
            if (!(y >= yMax)) continue;
            yMax = y;
        }
        return Coordinate.rectangleFromLtrb(xMin, yMax, xMax, yMin);
    }

    public static Coordinate getCentroid(List<Coordinate> coordinates) {
        if (coordinates == null) {
            return null;
        }
        double x = 0.0;
        double y = 0.0;
        double area2 = 0.0;
        Coordinate basePoint = coordinates.get(0);
        double xb = basePoint.x;
        double yb = basePoint.y;
        double minX = xb;
        double minY = yb;
        double maxX = xb;
        double maxY = yb;
        for (int i = 1; i < coordinates.size() - 1; ++i) {
            Coordinate point1 = coordinates.get(i);
            Coordinate point2 = coordinates.get(i + 1);
            double x1 = point1.x;
            double y1 = point1.y;
            double x2 = point2.x;
            double y2 = point2.y;
            if (minX > x1) {
                minX = x1;
            }
            if (maxX < x1) {
                maxX = x1;
            }
            if (minX > x2) {
                minX = x2;
            }
            if (maxX < x2) {
                maxX = x2;
            }
            if (minY > y1) {
                minY = y1;
            }
            if (maxY < y1) {
                maxY = y1;
            }
            if (minY > y2) {
                minY = y2;
            }
            if (maxY < y2) {
                maxY = y2;
            }
            double triangleCenterX3 = x1 + x2 + xb;
            double triangleCenterY3 = y1 + y2 + yb;
            double triangleArea2 = (x1 - xb) * (y2 - yb) - (x2 - xb) * (y1 - yb);
            x += triangleArea2 * triangleCenterX3;
            y += triangleArea2 * triangleCenterY3;
            area2 += triangleArea2;
        }
        if (area2 == 0.0) {
            return new Coordinate((maxX - minX) / 2.0, (maxY - minY) / 2.0);
        }
        return new Coordinate(x / (3.0 * area2), y / (3.0 * area2));
    }

    public static boolean intersectsWithPoly(double x, double y, List<Coordinate> polygon) {
        Coordinate first;
        if (polygon == null) {
            return false;
        }
        int count = polygon.size();
        if (count == 0) {
            return false;
        }
        Coordinate p1 = first = polygon.get(0);
        Coordinate p2 = polygon.get(1);
        int i = 0;
        boolean intersects = false;
        while (true) {
            double p2X;
            double p1Y;
            double p2Y;
            if ((p2Y = p2.y) > y != (p1Y = p1.y) > y && x < (p1.x - (p2X = p2.x)) * (y - p2Y) / (p1Y - p2Y) + p2X) {
                boolean bl = intersects = !intersects;
            }
            if (++i >= count) break;
            p1 = p2;
            p2 = polygon.get(i);
        }
        if (p2 != first && !p2.equals(first)) {
            throw new IllegalArgumentException("Object must be a polygon");
        }
        return intersects;
    }

    public static boolean isPolygon(List<Coordinate> feature) {
        int count = feature.size();
        if (count == 0) {
            return false;
        }
        return Objects.equals(feature.get(count - 1), feature.get(0));
    }

    public static List<Coordinate> rectangleFromLtrb(double left, double top, double right, double bottom) {
        Coordinate leftTop = new Coordinate(left, top);
        return Util.listOf(leftTop, new Coordinate(right, top), new Coordinate(right, bottom), new Coordinate(left, bottom), leftTop);
    }

    public double distanceFrom(Coordinate coordinate) {
        return Coordinate.distanceBetween(this.x, this.y, coordinate.x, coordinate.y);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Coordinate)) {
            return false;
        }
        double delta = this.x - ((Coordinate)obj).getX();
        if (delta < 0.0) {
            delta = -delta;
        }
        if (delta > 1.0E-7) {
            return false;
        }
        delta = this.y - ((Coordinate)obj).getY();
        if (delta < 0.0) {
            delta = -delta;
        }
        return delta <= 1.0E-7;
    }

    public int hashCode() {
        return Coordinate.roundToEpsilon(this.x).hashCode() ^ Coordinate.roundToEpsilon(this.y).hashCode();
    }

    public String toString() {
        return "X:" + this.x + "; Y:" + this.y;
    }

    static Coordinate getClosestPointOnSegment(double x, double y, Coordinate start, Coordinate end) {
        double x1 = start.x;
        double y1 = start.y;
        double x2 = end.x;
        double y2 = end.y;
        double a = x - x1;
        double b = y - y1;
        double c = x2 - x1;
        double d = y2 - y1;
        double dot = a * c + b * d;
        double lenSq = c * c + d * d;
        double param = dot / lenSq;
        if (lenSq == 0.0 || param < 0.0) {
            return new Coordinate(x1, y1);
        }
        if (param > 1.0) {
            return new Coordinate(x2, y2);
        }
        return new Coordinate(x1 + param * c, y1 + param * d);
    }

    static double getDistanceToSegment(double x, double y, List<Coordinate> polygon, int start, int end) {
        Coordinate point = polygon.get(start);
        if (end < 0 || end >= polygon.size()) {
            return Double.MAX_VALUE;
        }
        Coordinate nextPoint = polygon.get(end);
        Coordinate closest = Coordinate.getClosestPointOnSegment(x, y, nextPoint, point);
        return Coordinate.distanceBetween(x, y, closest.x, closest.y);
    }

    static Double roundToEpsilon(double value) {
        return (double)((int)(value / 1.0E-7 + 0.5)) * 1.0E-7;
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public Coordinate setX(double x) {
        this.x = x;
        return this;
    }

    @Generated
    public Coordinate setY(double y) {
        this.y = y;
        return this;
    }

    @Generated
    public Coordinate() {
    }

    @Generated
    public Coordinate(double x, double y) {
        this.x = x;
        this.y = y;
    }
}

