/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.drawing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.geotab.model.drawing.PointF;
import lombok.Generated;

public class RectangleF {
    public static final RectangleF EMPTY = new RectangleF(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
    private Float x;
    private Float y;
    private Float width;
    private Float height;

    @JsonIgnore
    public Float getLeft() {
        return this.x;
    }

    @JsonIgnore
    public Float getRight() {
        return Float.valueOf(this.x.floatValue() + this.width.floatValue());
    }

    @JsonIgnore
    public Float getTop() {
        return this.y;
    }

    @JsonIgnore
    public Float getBottom() {
        return Float.valueOf(this.y.floatValue() + this.height.floatValue());
    }

    @JsonIgnore
    public PointF getLocation() {
        return new PointF(this.x, this.y);
    }

    @JsonIgnore
    public RectangleF offset(PointF point) {
        return new RectangleF(Float.valueOf(this.x.floatValue() + point.getX().floatValue()), Float.valueOf(this.y.floatValue() + point.getY().floatValue()), this.width, this.height);
    }

    public static RectangleF fromLtrb(float left, float top, float right, float bottom) {
        return new RectangleF(Float.valueOf(left), Float.valueOf(top), Float.valueOf(right - left), Float.valueOf(bottom - top));
    }

    @Generated
    public static RectangleFBuilder builder() {
        return new RectangleFBuilder();
    }

    @Generated
    public Float getX() {
        return this.x;
    }

    @Generated
    public Float getY() {
        return this.y;
    }

    @Generated
    public Float getWidth() {
        return this.width;
    }

    @Generated
    public Float getHeight() {
        return this.height;
    }

    @Generated
    public RectangleF setX(Float x) {
        this.x = x;
        return this;
    }

    @Generated
    public RectangleF setY(Float y) {
        this.y = y;
        return this;
    }

    @Generated
    public RectangleF setWidth(Float width) {
        this.width = width;
        return this;
    }

    @Generated
    public RectangleF setHeight(Float height) {
        this.height = height;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RectangleF)) {
            return false;
        }
        RectangleF other = (RectangleF)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$x = this.getX();
        Float other$x = other.getX();
        if (this$x == null ? other$x != null : !((Object)this$x).equals(other$x)) {
            return false;
        }
        Float this$y = this.getY();
        Float other$y = other.getY();
        if (this$y == null ? other$y != null : !((Object)this$y).equals(other$y)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        return !(this$height == null ? other$height != null : !((Object)this$height).equals(other$height));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RectangleF;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $x = this.getX();
        result = result * 59 + ($x == null ? 43 : ((Object)$x).hashCode());
        Float $y = this.getY();
        result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RectangleF(x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
    }

    @Generated
    public RectangleF() {
    }

    @Generated
    public RectangleF(Float x, Float y, Float width, Float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Generated
    public static class RectangleFBuilder {
        @Generated
        private Float x;
        @Generated
        private Float y;
        @Generated
        private Float width;
        @Generated
        private Float height;

        @Generated
        RectangleFBuilder() {
        }

        @Generated
        public RectangleFBuilder x(Float x) {
            this.x = x;
            return this;
        }

        @Generated
        public RectangleFBuilder y(Float y) {
            this.y = y;
            return this;
        }

        @Generated
        public RectangleFBuilder width(Float width) {
            this.width = width;
            return this;
        }

        @Generated
        public RectangleFBuilder height(Float height) {
            this.height = height;
            return this;
        }

        @Generated
        public RectangleF build() {
            return new RectangleF(this.x, this.y, this.width, this.height);
        }

        @Generated
        public String toString() {
            return "RectangleF.RectangleFBuilder(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ")";
        }
    }
}

