/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.NameEntityWithVersion;
import com.geotab.model.entity.customproperty.PropertyValue;
import com.geotab.model.entity.device.DeviceFlags;
import com.geotab.model.entity.device.DevicePlan;
import com.geotab.model.entity.device.DevicePlanBillingInfo;
import com.geotab.model.entity.device.DeviceType;
import com.geotab.model.entity.file.MediaFile;
import com.geotab.model.entity.group.CompanyGroup;
import com.geotab.model.entity.group.Group;
import com.geotab.model.entity.worktime.WorkTime;
import com.geotab.model.entity.worktime.WorkTimeStandardHours;
import com.geotab.model.serialization.DeviceDeserializer;
import com.geotab.model.serialization.EntityCollectionAsIdCollectionSerializer;
import com.geotab.util.ThirdPartyHelper;
import com.geotab.util.Util;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

@JsonDeserialize(using=DeviceDeserializer.class)
public class Device
extends NameEntityWithVersion {
    public static final Float DEFAULT_MAX_NO_LOG_SECONDS = Float.valueOf(200.0f);
    public static final LocalDateTime MAX_DATE = LocalDateTime.of(2050, 1, 1, 0, 0, 0, 0);
    public static final LocalDateTime MIN_DATE = LocalDateTime.of(1986, 1, 1, 0, 0, 0, 0);
    public static final String HISTORIC_SERIAL_NUMBER = "000-000-0000";
    public static final int HISTORIC_MIN = 1000000;
    public static final int HISTORIC_MAX = 10000000;
    public static final int CUSTOM_DEVICE_PRODUCT_ID = 10000;
    public static final int GO_DRIVE_PRODUCT_ID = 256;
    public static final String GO_DRIVE_PREFIX = "GD";
    public static final int GO2_PRODUCT_ID = 1;
    public static final String GO2_PREFIX = "GT";
    public static final int GO3_PRODUCT_ID = 64;
    public static final String GO3_PREFIX = "G3";
    public static final int GO4_PRODUCT_ID = 65;
    public static final String GO4_PREFIX = "G4";
    public static final int GO4_V3_PRODUCT_ID = 81;
    public static final String GO4_V3_PREFIX = "GV";
    public static final int GO5_PRODUCT_ID = 90;
    public static final String GO5_PREFIX = "G5";
    public static final int GO6_PRODUCT_ID = 101;
    public static final String GO6_PREFIX = "G6";
    public static final int GO7_PRODUCT_ID = 105;
    public static final String GO7_PREFIX = "G7";
    public static final int GO8_PRODUCT_ID = 114;
    public static final String GO8_PREFIX = "G8";
    public static final int GO8_PRODUCT_ID_NO_GPS = 116;
    public static final int GO9_PRODUCT_ID = 120;
    public static final String GO9_PREFIX = "G9";
    public static final int GO9B_PRODUCT_ID = 124;
    public static final String GO9B_PREFIX = "GA";
    public static final int GO10_PRODUCT_ID = 124;
    public static final String GO10_PREFIX = "GA";
    public static final String A1_PREFIX = "A1";
    public static final int A1_PRODUCT_ID = 255;
    public static final String U1_PREFIX = "U1";
    public static final int U1_PRODUCT_ID = 130;
    public static final int GO9_PRODUCT_ID_NO_GPS = 121;
    public static final int GO_MAX_PRODUCT_ID = 254;
    public static final int UNTRACKED_ASSET_PRODUCT_ID = -1;
    public static final int UNTRACKED_ASSET_HARDWARE_ID = -1;
    public static final int OLD_GEOTAB_PRODUCT_ID = 0;
    public static final Map<String, Integer> GO_PREFIX_TO_PRODUCT_ID_MAPPING = Util.mapBuilder().put("GT", 1).put("G3", 64).put("G4", 65).put("GV", 81).put("G5", 90).put("G6", 101).put("G7", 105).put("G8", 114).put("G9", 120).put("GA", 124).put("GA", 124).put("GD", 256).put("A1", 255).put("U1", 130).build();
    protected DeviceType deviceType;
    protected Integer productId;
    protected String serialNumber;
    protected LocalDateTime ignoreDownloadsUntil;
    protected Duration timeToDownload;
    protected WorkTime workTime;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    protected List<Group> groups;
    protected List<DevicePlan> devicePlans;
    protected List<DevicePlanBillingInfo> devicePlanBillingInfo;
    protected String timeZoneId;
    protected Float minSecondsBetweenLogs;
    protected Float maxSecondsBetweenLogs;
    protected LocalDateTime activeFrom;
    protected LocalDateTime activeTo;
    protected String comment;
    protected DeviceFlags deviceFlags;
    protected Map<String, Object> customFeatures;
    protected List<PropertyValue> customProperties;
    protected List<MediaFile> mediaFiles;

    public static DeviceType deviceTypeFromProductId(int productId) {
        if (productId < 0) {
            return DeviceType.NONE;
        }
        if (productId == 0) {
            return DeviceType.OLD_GEOTAB;
        }
        if (productId <= 31 || productId >= 40 && productId <= 55) {
            return DeviceType.GO2;
        }
        if (productId <= 39 || productId >= 56 && productId < 65) {
            return DeviceType.GO3;
        }
        if (productId >= 65 && productId < 81) {
            return DeviceType.GO4;
        }
        if (productId >= 81 && productId < 90) {
            return DeviceType.GO4V3;
        }
        if (productId >= 90 && productId < 101) {
            return DeviceType.GO5;
        }
        if (productId >= 101 && productId < 105) {
            return DeviceType.GO6;
        }
        if (productId >= 105 && productId < 114) {
            return DeviceType.GO7;
        }
        if (productId >= 114 && productId < 120) {
            return DeviceType.GO8;
        }
        if (productId >= 120 && productId < 124) {
            return DeviceType.GO9;
        }
        if (productId >= 124 && productId < 124) {
            return DeviceType.GO9B;
        }
        if (productId >= 124 && productId <= 254) {
            return DeviceType.GO10;
        }
        if (productId == 255) {
            return DeviceType.A1;
        }
        if (productId == 130) {
            return DeviceType.U1;
        }
        if (productId == 256) {
            return DeviceType.GO_DRIVE_DEVICE;
        }
        if (ThirdPartyHelper.isThirdPartyVehicleDevice(productId)) {
            return DeviceType.CUSTOM_VEHICLE_DEVICE;
        }
        if (ThirdPartyHelper.isThirdPartyDevice(productId)) {
            return DeviceType.CUSTOM_DEVICE;
        }
        return DeviceType.NONE;
    }

    public static int productIdFromSerialNumber(String serialNumber) {
        int productId = 0;
        if (serialNumber.length() >= 2) {
            String prefix = serialNumber.substring(0, 2);
            if (GO_PREFIX_TO_PRODUCT_ID_MAPPING.containsKey(prefix)) {
                return GO_PREFIX_TO_PRODUCT_ID_MAPPING.get(prefix);
            }
            return ThirdPartyHelper.getThirdPartyProductId(serialNumber);
        }
        return productId;
    }

    public static String prefixFromDeviceType(int productId) {
        String prefix = Device.deviceTypeFromProductId(productId).getPrefix();
        if (!prefix.isEmpty()) {
            return prefix;
        }
        return ThirdPartyHelper.THIRD_PARTY_DEVICE_TYPES.getOrDefault(productId, "");
    }

    @JsonIgnore
    public boolean isNoGpsDevice() {
        return this.productId == 116 || this.productId == 121;
    }

    public static Device fromSerialNumber(String serialNumber) {
        int productId = Device.productIdFromSerialNumber(serialNumber);
        Device device = Device.fromProductId(productId);
        device.serialNumber = serialNumber;
        return device;
    }

    public void populateDefaults() {
        this.comment = Optional.ofNullable(this.comment).orElse("");
        this.timeToDownload = Optional.ofNullable(this.timeToDownload).orElse(Duration.ofMillis(86400000L));
        this.ignoreDownloadsUntil = Optional.ofNullable(this.ignoreDownloadsUntil).orElse(MIN_DATE);
        this.timeZoneId = Optional.ofNullable(this.timeZoneId).orElse("America/New_York");
        this.groups = Optional.ofNullable(this.groups).orElse(Util.listOf(new CompanyGroup()));
        this.maxSecondsBetweenLogs = Optional.ofNullable(this.maxSecondsBetweenLogs).orElse(DEFAULT_MAX_NO_LOG_SECONDS);
        this.workTime = Optional.ofNullable(this.workTime).orElse(new WorkTimeStandardHours());
        this.activeTo = MAX_DATE;
        this.activeFrom = Optional.ofNullable(this.activeFrom).orElse(LocalDateTime.now(ZoneOffset.UTC));
    }

    public static Device fromProductId(int productId) {
        DeviceType deviceType = Device.deviceTypeFromProductId(productId);
        Device device = deviceType.newInstance();
        device.productId = productId;
        return device;
    }

    @Generated
    protected Device(DeviceBuilder<?, ?> b) {
        super((NameEntityWithVersion.NameEntityWithVersionBuilder<?, ?>)b);
        this.deviceType = ((DeviceBuilder)b).deviceType;
        this.productId = ((DeviceBuilder)b).productId;
        this.serialNumber = ((DeviceBuilder)b).serialNumber;
        this.ignoreDownloadsUntil = ((DeviceBuilder)b).ignoreDownloadsUntil;
        this.timeToDownload = ((DeviceBuilder)b).timeToDownload;
        this.workTime = ((DeviceBuilder)b).workTime;
        this.groups = ((DeviceBuilder)b).groups;
        this.devicePlans = ((DeviceBuilder)b).devicePlans;
        this.devicePlanBillingInfo = ((DeviceBuilder)b).devicePlanBillingInfo;
        this.timeZoneId = ((DeviceBuilder)b).timeZoneId;
        this.minSecondsBetweenLogs = ((DeviceBuilder)b).minSecondsBetweenLogs;
        this.maxSecondsBetweenLogs = ((DeviceBuilder)b).maxSecondsBetweenLogs;
        this.activeFrom = ((DeviceBuilder)b).activeFrom;
        this.activeTo = ((DeviceBuilder)b).activeTo;
        this.comment = ((DeviceBuilder)b).comment;
        this.deviceFlags = ((DeviceBuilder)b).deviceFlags;
        this.customFeatures = ((DeviceBuilder)b).customFeatures;
        this.customProperties = ((DeviceBuilder)b).customProperties;
        this.mediaFiles = ((DeviceBuilder)b).mediaFiles;
    }

    @Generated
    public static DeviceBuilder<?, ?> builder() {
        return new DeviceBuilderImpl();
    }

    @Generated
    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public Integer getProductId() {
        return this.productId;
    }

    @Generated
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Generated
    public LocalDateTime getIgnoreDownloadsUntil() {
        return this.ignoreDownloadsUntil;
    }

    @Generated
    public Duration getTimeToDownload() {
        return this.timeToDownload;
    }

    @Generated
    public WorkTime getWorkTime() {
        return this.workTime;
    }

    @Generated
    public List<Group> getGroups() {
        return this.groups;
    }

    @Generated
    public List<DevicePlan> getDevicePlans() {
        return this.devicePlans;
    }

    @Generated
    public List<DevicePlanBillingInfo> getDevicePlanBillingInfo() {
        return this.devicePlanBillingInfo;
    }

    @Generated
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Generated
    public Float getMinSecondsBetweenLogs() {
        return this.minSecondsBetweenLogs;
    }

    @Generated
    public Float getMaxSecondsBetweenLogs() {
        return this.maxSecondsBetweenLogs;
    }

    @Generated
    public LocalDateTime getActiveFrom() {
        return this.activeFrom;
    }

    @Generated
    public LocalDateTime getActiveTo() {
        return this.activeTo;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public DeviceFlags getDeviceFlags() {
        return this.deviceFlags;
    }

    @Generated
    public Map<String, Object> getCustomFeatures() {
        return this.customFeatures;
    }

    @Generated
    public List<PropertyValue> getCustomProperties() {
        return this.customProperties;
    }

    @Generated
    public List<MediaFile> getMediaFiles() {
        return this.mediaFiles;
    }

    @Generated
    public Device setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    @Generated
    public Device setProductId(Integer productId) {
        this.productId = productId;
        return this;
    }

    @Generated
    public Device setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @Generated
    public Device setIgnoreDownloadsUntil(LocalDateTime ignoreDownloadsUntil) {
        this.ignoreDownloadsUntil = ignoreDownloadsUntil;
        return this;
    }

    @Generated
    public Device setTimeToDownload(Duration timeToDownload) {
        this.timeToDownload = timeToDownload;
        return this;
    }

    @Generated
    public Device setWorkTime(WorkTime workTime) {
        this.workTime = workTime;
        return this;
    }

    @Generated
    public Device setGroups(List<Group> groups) {
        this.groups = groups;
        return this;
    }

    @Generated
    public Device setDevicePlans(List<DevicePlan> devicePlans) {
        this.devicePlans = devicePlans;
        return this;
    }

    @Generated
    public Device setDevicePlanBillingInfo(List<DevicePlanBillingInfo> devicePlanBillingInfo) {
        this.devicePlanBillingInfo = devicePlanBillingInfo;
        return this;
    }

    @Generated
    public Device setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    @Generated
    public Device setMinSecondsBetweenLogs(Float minSecondsBetweenLogs) {
        this.minSecondsBetweenLogs = minSecondsBetweenLogs;
        return this;
    }

    @Generated
    public Device setMaxSecondsBetweenLogs(Float maxSecondsBetweenLogs) {
        this.maxSecondsBetweenLogs = maxSecondsBetweenLogs;
        return this;
    }

    @Generated
    public Device setActiveFrom(LocalDateTime activeFrom) {
        this.activeFrom = activeFrom;
        return this;
    }

    @Generated
    public Device setActiveTo(LocalDateTime activeTo) {
        this.activeTo = activeTo;
        return this;
    }

    @Generated
    public Device setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Generated
    public Device setDeviceFlags(DeviceFlags deviceFlags) {
        this.deviceFlags = deviceFlags;
        return this;
    }

    @Generated
    public Device setCustomFeatures(Map<String, Object> customFeatures) {
        this.customFeatures = customFeatures;
        return this;
    }

    @Generated
    public Device setCustomProperties(List<PropertyValue> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    @Generated
    public Device setMediaFiles(List<MediaFile> mediaFiles) {
        this.mediaFiles = mediaFiles;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Device)) {
            return false;
        }
        Device other = (Device)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$productId = this.getProductId();
        Integer other$productId = other.getProductId();
        if (this$productId == null ? other$productId != null : !((Object)this$productId).equals(other$productId)) {
            return false;
        }
        Float this$minSecondsBetweenLogs = this.getMinSecondsBetweenLogs();
        Float other$minSecondsBetweenLogs = other.getMinSecondsBetweenLogs();
        if (this$minSecondsBetweenLogs == null ? other$minSecondsBetweenLogs != null : !((Object)this$minSecondsBetweenLogs).equals(other$minSecondsBetweenLogs)) {
            return false;
        }
        Float this$maxSecondsBetweenLogs = this.getMaxSecondsBetweenLogs();
        Float other$maxSecondsBetweenLogs = other.getMaxSecondsBetweenLogs();
        if (this$maxSecondsBetweenLogs == null ? other$maxSecondsBetweenLogs != null : !((Object)this$maxSecondsBetweenLogs).equals(other$maxSecondsBetweenLogs)) {
            return false;
        }
        DeviceType this$deviceType = this.getDeviceType();
        DeviceType other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        if (this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber)) {
            return false;
        }
        LocalDateTime this$ignoreDownloadsUntil = this.getIgnoreDownloadsUntil();
        LocalDateTime other$ignoreDownloadsUntil = other.getIgnoreDownloadsUntil();
        if (this$ignoreDownloadsUntil == null ? other$ignoreDownloadsUntil != null : !((Object)this$ignoreDownloadsUntil).equals(other$ignoreDownloadsUntil)) {
            return false;
        }
        Duration this$timeToDownload = this.getTimeToDownload();
        Duration other$timeToDownload = other.getTimeToDownload();
        if (this$timeToDownload == null ? other$timeToDownload != null : !((Object)this$timeToDownload).equals(other$timeToDownload)) {
            return false;
        }
        WorkTime this$workTime = this.getWorkTime();
        WorkTime other$workTime = other.getWorkTime();
        if (this$workTime == null ? other$workTime != null : !((Object)this$workTime).equals(other$workTime)) {
            return false;
        }
        List<Group> this$groups = this.getGroups();
        List<Group> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        List<DevicePlan> this$devicePlans = this.getDevicePlans();
        List<DevicePlan> other$devicePlans = other.getDevicePlans();
        if (this$devicePlans == null ? other$devicePlans != null : !((Object)this$devicePlans).equals(other$devicePlans)) {
            return false;
        }
        List<DevicePlanBillingInfo> this$devicePlanBillingInfo = this.getDevicePlanBillingInfo();
        List<DevicePlanBillingInfo> other$devicePlanBillingInfo = other.getDevicePlanBillingInfo();
        if (this$devicePlanBillingInfo == null ? other$devicePlanBillingInfo != null : !((Object)this$devicePlanBillingInfo).equals(other$devicePlanBillingInfo)) {
            return false;
        }
        String this$timeZoneId = this.getTimeZoneId();
        String other$timeZoneId = other.getTimeZoneId();
        if (this$timeZoneId == null ? other$timeZoneId != null : !this$timeZoneId.equals(other$timeZoneId)) {
            return false;
        }
        LocalDateTime this$activeFrom = this.getActiveFrom();
        LocalDateTime other$activeFrom = other.getActiveFrom();
        if (this$activeFrom == null ? other$activeFrom != null : !((Object)this$activeFrom).equals(other$activeFrom)) {
            return false;
        }
        LocalDateTime this$activeTo = this.getActiveTo();
        LocalDateTime other$activeTo = other.getActiveTo();
        if (this$activeTo == null ? other$activeTo != null : !((Object)this$activeTo).equals(other$activeTo)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        DeviceFlags this$deviceFlags = this.getDeviceFlags();
        DeviceFlags other$deviceFlags = other.getDeviceFlags();
        if (this$deviceFlags == null ? other$deviceFlags != null : !((Object)this$deviceFlags).equals(other$deviceFlags)) {
            return false;
        }
        Map<String, Object> this$customFeatures = this.getCustomFeatures();
        Map<String, Object> other$customFeatures = other.getCustomFeatures();
        if (this$customFeatures == null ? other$customFeatures != null : !((Object)this$customFeatures).equals(other$customFeatures)) {
            return false;
        }
        List<PropertyValue> this$customProperties = this.getCustomProperties();
        List<PropertyValue> other$customProperties = other.getCustomProperties();
        if (this$customProperties == null ? other$customProperties != null : !((Object)this$customProperties).equals(other$customProperties)) {
            return false;
        }
        List<MediaFile> this$mediaFiles = this.getMediaFiles();
        List<MediaFile> other$mediaFiles = other.getMediaFiles();
        return !(this$mediaFiles == null ? other$mediaFiles != null : !((Object)this$mediaFiles).equals(other$mediaFiles));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Device;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $productId = this.getProductId();
        result = result * 59 + ($productId == null ? 43 : ((Object)$productId).hashCode());
        Float $minSecondsBetweenLogs = this.getMinSecondsBetweenLogs();
        result = result * 59 + ($minSecondsBetweenLogs == null ? 43 : ((Object)$minSecondsBetweenLogs).hashCode());
        Float $maxSecondsBetweenLogs = this.getMaxSecondsBetweenLogs();
        result = result * 59 + ($maxSecondsBetweenLogs == null ? 43 : ((Object)$maxSecondsBetweenLogs).hashCode());
        DeviceType $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        LocalDateTime $ignoreDownloadsUntil = this.getIgnoreDownloadsUntil();
        result = result * 59 + ($ignoreDownloadsUntil == null ? 43 : ((Object)$ignoreDownloadsUntil).hashCode());
        Duration $timeToDownload = this.getTimeToDownload();
        result = result * 59 + ($timeToDownload == null ? 43 : ((Object)$timeToDownload).hashCode());
        WorkTime $workTime = this.getWorkTime();
        result = result * 59 + ($workTime == null ? 43 : ((Object)$workTime).hashCode());
        List<Group> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        List<DevicePlan> $devicePlans = this.getDevicePlans();
        result = result * 59 + ($devicePlans == null ? 43 : ((Object)$devicePlans).hashCode());
        List<DevicePlanBillingInfo> $devicePlanBillingInfo = this.getDevicePlanBillingInfo();
        result = result * 59 + ($devicePlanBillingInfo == null ? 43 : ((Object)$devicePlanBillingInfo).hashCode());
        String $timeZoneId = this.getTimeZoneId();
        result = result * 59 + ($timeZoneId == null ? 43 : $timeZoneId.hashCode());
        LocalDateTime $activeFrom = this.getActiveFrom();
        result = result * 59 + ($activeFrom == null ? 43 : ((Object)$activeFrom).hashCode());
        LocalDateTime $activeTo = this.getActiveTo();
        result = result * 59 + ($activeTo == null ? 43 : ((Object)$activeTo).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        DeviceFlags $deviceFlags = this.getDeviceFlags();
        result = result * 59 + ($deviceFlags == null ? 43 : ((Object)$deviceFlags).hashCode());
        Map<String, Object> $customFeatures = this.getCustomFeatures();
        result = result * 59 + ($customFeatures == null ? 43 : ((Object)$customFeatures).hashCode());
        List<PropertyValue> $customProperties = this.getCustomProperties();
        result = result * 59 + ($customProperties == null ? 43 : ((Object)$customProperties).hashCode());
        List<MediaFile> $mediaFiles = this.getMediaFiles();
        result = result * 59 + ($mediaFiles == null ? 43 : ((Object)$mediaFiles).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Device(super=" + super.toString() + ", deviceType=" + this.getDeviceType() + ", productId=" + this.getProductId() + ", serialNumber=" + this.getSerialNumber() + ", ignoreDownloadsUntil=" + this.getIgnoreDownloadsUntil() + ", timeToDownload=" + this.getTimeToDownload() + ", workTime=" + this.getWorkTime() + ", groups=" + this.getGroups() + ", devicePlans=" + this.getDevicePlans() + ", devicePlanBillingInfo=" + this.getDevicePlanBillingInfo() + ", timeZoneId=" + this.getTimeZoneId() + ", minSecondsBetweenLogs=" + this.getMinSecondsBetweenLogs() + ", maxSecondsBetweenLogs=" + this.getMaxSecondsBetweenLogs() + ", activeFrom=" + this.getActiveFrom() + ", activeTo=" + this.getActiveTo() + ", comment=" + this.getComment() + ", deviceFlags=" + this.getDeviceFlags() + ", customFeatures=" + this.getCustomFeatures() + ", customProperties=" + this.getCustomProperties() + ", mediaFiles=" + this.getMediaFiles() + ")";
    }

    @Generated
    public Device() {
    }

    @Generated
    private static final class DeviceBuilderImpl
    extends DeviceBuilder<Device, DeviceBuilderImpl> {
        @Generated
        private DeviceBuilderImpl() {
        }

        @Override
        @Generated
        protected DeviceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Device build() {
            return new Device(this);
        }
    }

    @Generated
    public static abstract class DeviceBuilder<C extends Device, B extends DeviceBuilder<C, B>>
    extends NameEntityWithVersion.NameEntityWithVersionBuilder<C, B> {
        @Generated
        private DeviceType deviceType;
        @Generated
        private Integer productId;
        @Generated
        private String serialNumber;
        @Generated
        private LocalDateTime ignoreDownloadsUntil;
        @Generated
        private Duration timeToDownload;
        @Generated
        private WorkTime workTime;
        @Generated
        private List<Group> groups;
        @Generated
        private List<DevicePlan> devicePlans;
        @Generated
        private List<DevicePlanBillingInfo> devicePlanBillingInfo;
        @Generated
        private String timeZoneId;
        @Generated
        private Float minSecondsBetweenLogs;
        @Generated
        private Float maxSecondsBetweenLogs;
        @Generated
        private LocalDateTime activeFrom;
        @Generated
        private LocalDateTime activeTo;
        @Generated
        private String comment;
        @Generated
        private DeviceFlags deviceFlags;
        @Generated
        private Map<String, Object> customFeatures;
        @Generated
        private List<PropertyValue> customProperties;
        @Generated
        private List<MediaFile> mediaFiles;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return (B)this.self();
        }

        @Generated
        public B productId(Integer productId) {
            this.productId = productId;
            return (B)this.self();
        }

        @Generated
        public B serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return (B)this.self();
        }

        @Generated
        public B ignoreDownloadsUntil(LocalDateTime ignoreDownloadsUntil) {
            this.ignoreDownloadsUntil = ignoreDownloadsUntil;
            return (B)this.self();
        }

        @Generated
        public B timeToDownload(Duration timeToDownload) {
            this.timeToDownload = timeToDownload;
            return (B)this.self();
        }

        @Generated
        public B workTime(WorkTime workTime) {
            this.workTime = workTime;
            return (B)this.self();
        }

        @Generated
        public B groups(List<Group> groups) {
            this.groups = groups;
            return (B)this.self();
        }

        @Generated
        public B devicePlans(List<DevicePlan> devicePlans) {
            this.devicePlans = devicePlans;
            return (B)this.self();
        }

        @Generated
        public B devicePlanBillingInfo(List<DevicePlanBillingInfo> devicePlanBillingInfo) {
            this.devicePlanBillingInfo = devicePlanBillingInfo;
            return (B)this.self();
        }

        @Generated
        public B timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return (B)this.self();
        }

        @Generated
        public B minSecondsBetweenLogs(Float minSecondsBetweenLogs) {
            this.minSecondsBetweenLogs = minSecondsBetweenLogs;
            return (B)this.self();
        }

        @Generated
        public B maxSecondsBetweenLogs(Float maxSecondsBetweenLogs) {
            this.maxSecondsBetweenLogs = maxSecondsBetweenLogs;
            return (B)this.self();
        }

        @Generated
        public B activeFrom(LocalDateTime activeFrom) {
            this.activeFrom = activeFrom;
            return (B)this.self();
        }

        @Generated
        public B activeTo(LocalDateTime activeTo) {
            this.activeTo = activeTo;
            return (B)this.self();
        }

        @Generated
        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        @Generated
        public B deviceFlags(DeviceFlags deviceFlags) {
            this.deviceFlags = deviceFlags;
            return (B)this.self();
        }

        @Generated
        public B customFeatures(Map<String, Object> customFeatures) {
            this.customFeatures = customFeatures;
            return (B)this.self();
        }

        @Generated
        public B customProperties(List<PropertyValue> customProperties) {
            this.customProperties = customProperties;
            return (B)this.self();
        }

        @Generated
        public B mediaFiles(List<MediaFile> mediaFiles) {
            this.mediaFiles = mediaFiles;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Device.DeviceBuilder(super=" + super.toString() + ", deviceType=" + this.deviceType + ", productId=" + this.productId + ", serialNumber=" + this.serialNumber + ", ignoreDownloadsUntil=" + this.ignoreDownloadsUntil + ", timeToDownload=" + this.timeToDownload + ", workTime=" + this.workTime + ", groups=" + this.groups + ", devicePlans=" + this.devicePlans + ", devicePlanBillingInfo=" + this.devicePlanBillingInfo + ", timeZoneId=" + this.timeZoneId + ", minSecondsBetweenLogs=" + this.minSecondsBetweenLogs + ", maxSecondsBetweenLogs=" + this.maxSecondsBetweenLogs + ", activeFrom=" + this.activeFrom + ", activeTo=" + this.activeTo + ", comment=" + this.comment + ", deviceFlags=" + this.deviceFlags + ", customFeatures=" + this.customFeatures + ", customProperties=" + this.customProperties + ", mediaFiles=" + this.mediaFiles + ")";
        }
    }
}

