/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.device;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.CustomParameter;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.device.DeviceType;
import com.geotab.model.entity.device.GoTalkLanguage;
import com.geotab.model.entity.device.HosOption;
import com.geotab.model.entity.device.LicensableAware;
import com.geotab.model.entity.device.VehicleIdentificationNumberAware;
import com.geotab.model.entity.enginetype.EngineType;
import com.geotab.model.entity.group.Group;
import com.geotab.model.serialization.EntityCollectionAsIdCollectionSerializer;
import com.geotab.model.wifi.WifiUsageTier;
import com.geotab.util.DeviceDefaultsUtil;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public abstract class GoDevice
extends Device
implements VehicleIdentificationNumberAware,
LicensableAware {
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    protected List<Group> autoGroups;
    private List<CustomParameter> customParameters;
    private boolean disableBuzzer;
    private boolean enableBeepOnIdle;
    private boolean enableMustReprogram;
    private boolean enableSpeedWarning;
    private EngineType engineType;
    private String engineVehicleIdentificationNumber;
    private boolean ensureHotStart;
    private Integer gpsOffDelay;
    private Integer idleMinutes;
    private Boolean isSpeedIndicator;
    private String licensePlate;
    private String licenseState;
    private Short major;
    private Double minAccidentSpeed;
    private Short minor;
    private Integer parameterVersion;
    private Boolean pinDevice;
    private Double speedingOff;
    private Double speedingOn;
    private String vehicleIdentificationNumber;
    private GoTalkLanguage goTalkLanguage;
    private Double fuelTankCapacity;
    private Boolean disableSleeperBerth;
    private HosOption autoHos;
    private List<WifiUsageTier> wifiHotspotLimits;
    private Short parameterVersionOnDevice;

    @Override
    public Boolean isPinDevice() {
        return this.getPinDevice();
    }

    @JsonIgnore
    public Boolean isExternalDevicePowerControlSupported() {
        if (this.deviceType == null || this.productId == null) {
            return null;
        }
        return this.deviceType == DeviceType.GO9 || this.deviceType == DeviceType.GO9B || this.deviceType == DeviceType.GO8 || this.deviceType == DeviceType.GO7 || this.deviceType == DeviceType.GO6 || this.deviceType == DeviceType.GO4V3 || this.productId == 66 || this.productId >= 78 && this.productId <= 80;
    }

    public static int byteToDegrees(short value) {
        return (int)Math.round(2.403 * (double)value);
    }

    public static double byteToSpeed(short value) {
        return (double)value * 3.6 * 0.512;
    }

    public static boolean[] checkAndPadAuxArray(boolean[] booleanArray) {
        if (booleanArray == null) {
            return new boolean[8];
        }
        if (booleanArray.length > 8) {
            throw new IllegalArgumentException("booleanArray.length cannot be more then 8");
        }
        return Arrays.copyOf(booleanArray, 8);
    }

    public static double[] checkAndPadAuxArray(double[] doubleArray) {
        if (doubleArray == null) {
            return new double[8];
        }
        if (doubleArray.length > 8) {
            throw new IllegalArgumentException("doubleArray.length cannot be more then 8");
        }
        return Arrays.copyOf(doubleArray, 8);
    }

    public static boolean[] checkAndPadAuxIgnArray(boolean[] booleanArray) {
        if (booleanArray == null) {
            return new boolean[4];
        }
        if (booleanArray.length > 4) {
            throw new IllegalArgumentException("booleanArray.Length cannot be more then 4");
        }
        return Arrays.copyOf(booleanArray, 4);
    }

    public static short[] checkAndPadChannelArray(short[] shortArray) {
        if (shortArray == null) {
            return new short[20];
        }
        if (shortArray.length > 20) {
            throw new IllegalArgumentException("shortArray.length cannot be more then 20");
        }
        return Arrays.copyOf(shortArray, 20);
    }

    public static short degreesToByte(int value) {
        return (short)Math.round((double)value / 2.403);
    }

    public static short speedToByte(double value) {
        return (short)Math.round(value / 3.6 / 0.512);
    }

    @JsonIgnore
    public Boolean isGarminSupported() {
        if (this.deviceType == null || this.productId == null) {
            return null;
        }
        return this.deviceType == DeviceType.GO9 || this.deviceType == DeviceType.GO9B || this.deviceType == DeviceType.GO8 || this.deviceType == DeviceType.GO7 || this.deviceType == DeviceType.GO6 || this.deviceType == DeviceType.GO4V3 || this.productId == 66 || this.productId == 80;
    }

    @JsonIgnore
    public Boolean isRFDevice() {
        if (this.productId == null) {
            return null;
        }
        switch (this.productId) {
            case 3: 
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 32: 
            case 36: 
            case 38: 
            case 39: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 82: 
            case 84: {
                return true;
            }
            case 17: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 35: 
            case 37: 
            case 65: 
            case 66: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 79: 
            case 80: 
            case 81: 
            case 83: {
                return false;
            }
        }
        return this.deviceType == DeviceType.GO5 || this.deviceType == DeviceType.GO6 || this.deviceType == DeviceType.GO7 || this.deviceType == DeviceType.GO8 || this.deviceType == DeviceType.GO9 || this.deviceType == DeviceType.GO9B || this.deviceType == DeviceType.CUSTOM_DEVICE || this.deviceType == DeviceType.CUSTOM_VEHICLE_DEVICE || this.deviceType == DeviceType.GO_DRIVE_DEVICE ? Boolean.valueOf(false) : null;
    }

    @Override
    public void populateDefaults() {
        super.populateDefaults();
        DeviceDefaultsUtil.addVehicleIdentificationNumberDefaults(this);
        DeviceDefaultsUtil.addGoDeviceDefaults(this);
    }

    @Generated
    protected GoDevice(GoDeviceBuilder<?, ?> b) {
        super((Device.DeviceBuilder<?, ?>)b);
        this.autoGroups = ((GoDeviceBuilder)b).autoGroups;
        this.customParameters = ((GoDeviceBuilder)b).customParameters;
        this.disableBuzzer = ((GoDeviceBuilder)b).disableBuzzer;
        this.enableBeepOnIdle = ((GoDeviceBuilder)b).enableBeepOnIdle;
        this.enableMustReprogram = ((GoDeviceBuilder)b).enableMustReprogram;
        this.enableSpeedWarning = ((GoDeviceBuilder)b).enableSpeedWarning;
        this.engineType = ((GoDeviceBuilder)b).engineType;
        this.engineVehicleIdentificationNumber = ((GoDeviceBuilder)b).engineVehicleIdentificationNumber;
        this.ensureHotStart = ((GoDeviceBuilder)b).ensureHotStart;
        this.gpsOffDelay = ((GoDeviceBuilder)b).gpsOffDelay;
        this.idleMinutes = ((GoDeviceBuilder)b).idleMinutes;
        this.isSpeedIndicator = ((GoDeviceBuilder)b).isSpeedIndicator;
        this.licensePlate = ((GoDeviceBuilder)b).licensePlate;
        this.licenseState = ((GoDeviceBuilder)b).licenseState;
        this.major = ((GoDeviceBuilder)b).major;
        this.minAccidentSpeed = ((GoDeviceBuilder)b).minAccidentSpeed;
        this.minor = ((GoDeviceBuilder)b).minor;
        this.parameterVersion = ((GoDeviceBuilder)b).parameterVersion;
        this.pinDevice = ((GoDeviceBuilder)b).pinDevice;
        this.speedingOff = ((GoDeviceBuilder)b).speedingOff;
        this.speedingOn = ((GoDeviceBuilder)b).speedingOn;
        this.vehicleIdentificationNumber = ((GoDeviceBuilder)b).vehicleIdentificationNumber;
        this.goTalkLanguage = ((GoDeviceBuilder)b).goTalkLanguage;
        this.fuelTankCapacity = ((GoDeviceBuilder)b).fuelTankCapacity;
        this.disableSleeperBerth = ((GoDeviceBuilder)b).disableSleeperBerth;
        this.autoHos = ((GoDeviceBuilder)b).autoHos;
        this.wifiHotspotLimits = ((GoDeviceBuilder)b).wifiHotspotLimits;
        this.parameterVersionOnDevice = ((GoDeviceBuilder)b).parameterVersionOnDevice;
    }

    @Generated
    public List<Group> getAutoGroups() {
        return this.autoGroups;
    }

    @Generated
    public List<CustomParameter> getCustomParameters() {
        return this.customParameters;
    }

    @Generated
    public boolean isDisableBuzzer() {
        return this.disableBuzzer;
    }

    @Generated
    public boolean isEnableBeepOnIdle() {
        return this.enableBeepOnIdle;
    }

    @Generated
    public boolean isEnableMustReprogram() {
        return this.enableMustReprogram;
    }

    @Generated
    public boolean isEnableSpeedWarning() {
        return this.enableSpeedWarning;
    }

    @Generated
    public EngineType getEngineType() {
        return this.engineType;
    }

    @Override
    @Generated
    public String getEngineVehicleIdentificationNumber() {
        return this.engineVehicleIdentificationNumber;
    }

    @Generated
    public boolean isEnsureHotStart() {
        return this.ensureHotStart;
    }

    @Generated
    public Integer getGpsOffDelay() {
        return this.gpsOffDelay;
    }

    @Generated
    public Integer getIdleMinutes() {
        return this.idleMinutes;
    }

    @Generated
    public Boolean getIsSpeedIndicator() {
        return this.isSpeedIndicator;
    }

    @Override
    @Generated
    public String getLicensePlate() {
        return this.licensePlate;
    }

    @Override
    @Generated
    public String getLicenseState() {
        return this.licenseState;
    }

    @Generated
    public Short getMajor() {
        return this.major;
    }

    @Generated
    public Double getMinAccidentSpeed() {
        return this.minAccidentSpeed;
    }

    @Generated
    public Short getMinor() {
        return this.minor;
    }

    @Generated
    public Integer getParameterVersion() {
        return this.parameterVersion;
    }

    @Generated
    public Boolean getPinDevice() {
        return this.pinDevice;
    }

    @Generated
    public Double getSpeedingOff() {
        return this.speedingOff;
    }

    @Generated
    public Double getSpeedingOn() {
        return this.speedingOn;
    }

    @Override
    @Generated
    public String getVehicleIdentificationNumber() {
        return this.vehicleIdentificationNumber;
    }

    @Generated
    public GoTalkLanguage getGoTalkLanguage() {
        return this.goTalkLanguage;
    }

    @Generated
    public Double getFuelTankCapacity() {
        return this.fuelTankCapacity;
    }

    @Generated
    public Boolean getDisableSleeperBerth() {
        return this.disableSleeperBerth;
    }

    @Generated
    public HosOption getAutoHos() {
        return this.autoHos;
    }

    @Generated
    public List<WifiUsageTier> getWifiHotspotLimits() {
        return this.wifiHotspotLimits;
    }

    @Generated
    public Short getParameterVersionOnDevice() {
        return this.parameterVersionOnDevice;
    }

    @Generated
    public GoDevice setAutoGroups(List<Group> autoGroups) {
        this.autoGroups = autoGroups;
        return this;
    }

    @Generated
    public GoDevice setCustomParameters(List<CustomParameter> customParameters) {
        this.customParameters = customParameters;
        return this;
    }

    @Generated
    public GoDevice setDisableBuzzer(boolean disableBuzzer) {
        this.disableBuzzer = disableBuzzer;
        return this;
    }

    @Generated
    public GoDevice setEnableBeepOnIdle(boolean enableBeepOnIdle) {
        this.enableBeepOnIdle = enableBeepOnIdle;
        return this;
    }

    @Generated
    public GoDevice setEnableMustReprogram(boolean enableMustReprogram) {
        this.enableMustReprogram = enableMustReprogram;
        return this;
    }

    @Generated
    public GoDevice setEnableSpeedWarning(boolean enableSpeedWarning) {
        this.enableSpeedWarning = enableSpeedWarning;
        return this;
    }

    @Generated
    public GoDevice setEngineType(EngineType engineType) {
        this.engineType = engineType;
        return this;
    }

    @Override
    @Generated
    public GoDevice setEngineVehicleIdentificationNumber(String engineVehicleIdentificationNumber) {
        this.engineVehicleIdentificationNumber = engineVehicleIdentificationNumber;
        return this;
    }

    @Generated
    public GoDevice setEnsureHotStart(boolean ensureHotStart) {
        this.ensureHotStart = ensureHotStart;
        return this;
    }

    @Generated
    public GoDevice setGpsOffDelay(Integer gpsOffDelay) {
        this.gpsOffDelay = gpsOffDelay;
        return this;
    }

    @Generated
    public GoDevice setIdleMinutes(Integer idleMinutes) {
        this.idleMinutes = idleMinutes;
        return this;
    }

    @Generated
    public GoDevice setIsSpeedIndicator(Boolean isSpeedIndicator) {
        this.isSpeedIndicator = isSpeedIndicator;
        return this;
    }

    @Override
    @Generated
    public GoDevice setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
        return this;
    }

    @Override
    @Generated
    public GoDevice setLicenseState(String licenseState) {
        this.licenseState = licenseState;
        return this;
    }

    @Generated
    public GoDevice setMajor(Short major) {
        this.major = major;
        return this;
    }

    @Generated
    public GoDevice setMinAccidentSpeed(Double minAccidentSpeed) {
        this.minAccidentSpeed = minAccidentSpeed;
        return this;
    }

    @Generated
    public GoDevice setMinor(Short minor) {
        this.minor = minor;
        return this;
    }

    @Generated
    public GoDevice setParameterVersion(Integer parameterVersion) {
        this.parameterVersion = parameterVersion;
        return this;
    }

    @Override
    @Generated
    public GoDevice setPinDevice(Boolean pinDevice) {
        this.pinDevice = pinDevice;
        return this;
    }

    @Generated
    public GoDevice setSpeedingOff(Double speedingOff) {
        this.speedingOff = speedingOff;
        return this;
    }

    @Generated
    public GoDevice setSpeedingOn(Double speedingOn) {
        this.speedingOn = speedingOn;
        return this;
    }

    @Override
    @Generated
    public GoDevice setVehicleIdentificationNumber(String vehicleIdentificationNumber) {
        this.vehicleIdentificationNumber = vehicleIdentificationNumber;
        return this;
    }

    @Generated
    public GoDevice setGoTalkLanguage(GoTalkLanguage goTalkLanguage) {
        this.goTalkLanguage = goTalkLanguage;
        return this;
    }

    @Generated
    public GoDevice setFuelTankCapacity(Double fuelTankCapacity) {
        this.fuelTankCapacity = fuelTankCapacity;
        return this;
    }

    @Generated
    public GoDevice setDisableSleeperBerth(Boolean disableSleeperBerth) {
        this.disableSleeperBerth = disableSleeperBerth;
        return this;
    }

    @Generated
    public GoDevice setAutoHos(HosOption autoHos) {
        this.autoHos = autoHos;
        return this;
    }

    @Generated
    public GoDevice setWifiHotspotLimits(List<WifiUsageTier> wifiHotspotLimits) {
        this.wifiHotspotLimits = wifiHotspotLimits;
        return this;
    }

    @Generated
    public GoDevice setParameterVersionOnDevice(Short parameterVersionOnDevice) {
        this.parameterVersionOnDevice = parameterVersionOnDevice;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GoDevice)) {
            return false;
        }
        GoDevice other = (GoDevice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDisableBuzzer() != other.isDisableBuzzer()) {
            return false;
        }
        if (this.isEnableBeepOnIdle() != other.isEnableBeepOnIdle()) {
            return false;
        }
        if (this.isEnableMustReprogram() != other.isEnableMustReprogram()) {
            return false;
        }
        if (this.isEnableSpeedWarning() != other.isEnableSpeedWarning()) {
            return false;
        }
        if (this.isEnsureHotStart() != other.isEnsureHotStart()) {
            return false;
        }
        Integer this$gpsOffDelay = this.getGpsOffDelay();
        Integer other$gpsOffDelay = other.getGpsOffDelay();
        if (this$gpsOffDelay == null ? other$gpsOffDelay != null : !((Object)this$gpsOffDelay).equals(other$gpsOffDelay)) {
            return false;
        }
        Integer this$idleMinutes = this.getIdleMinutes();
        Integer other$idleMinutes = other.getIdleMinutes();
        if (this$idleMinutes == null ? other$idleMinutes != null : !((Object)this$idleMinutes).equals(other$idleMinutes)) {
            return false;
        }
        Boolean this$isSpeedIndicator = this.getIsSpeedIndicator();
        Boolean other$isSpeedIndicator = other.getIsSpeedIndicator();
        if (this$isSpeedIndicator == null ? other$isSpeedIndicator != null : !((Object)this$isSpeedIndicator).equals(other$isSpeedIndicator)) {
            return false;
        }
        Short this$major = this.getMajor();
        Short other$major = other.getMajor();
        if (this$major == null ? other$major != null : !((Object)this$major).equals(other$major)) {
            return false;
        }
        Double this$minAccidentSpeed = this.getMinAccidentSpeed();
        Double other$minAccidentSpeed = other.getMinAccidentSpeed();
        if (this$minAccidentSpeed == null ? other$minAccidentSpeed != null : !((Object)this$minAccidentSpeed).equals(other$minAccidentSpeed)) {
            return false;
        }
        Short this$minor = this.getMinor();
        Short other$minor = other.getMinor();
        if (this$minor == null ? other$minor != null : !((Object)this$minor).equals(other$minor)) {
            return false;
        }
        Integer this$parameterVersion = this.getParameterVersion();
        Integer other$parameterVersion = other.getParameterVersion();
        if (this$parameterVersion == null ? other$parameterVersion != null : !((Object)this$parameterVersion).equals(other$parameterVersion)) {
            return false;
        }
        Boolean this$pinDevice = this.getPinDevice();
        Boolean other$pinDevice = other.getPinDevice();
        if (this$pinDevice == null ? other$pinDevice != null : !((Object)this$pinDevice).equals(other$pinDevice)) {
            return false;
        }
        Double this$speedingOff = this.getSpeedingOff();
        Double other$speedingOff = other.getSpeedingOff();
        if (this$speedingOff == null ? other$speedingOff != null : !((Object)this$speedingOff).equals(other$speedingOff)) {
            return false;
        }
        Double this$speedingOn = this.getSpeedingOn();
        Double other$speedingOn = other.getSpeedingOn();
        if (this$speedingOn == null ? other$speedingOn != null : !((Object)this$speedingOn).equals(other$speedingOn)) {
            return false;
        }
        Double this$fuelTankCapacity = this.getFuelTankCapacity();
        Double other$fuelTankCapacity = other.getFuelTankCapacity();
        if (this$fuelTankCapacity == null ? other$fuelTankCapacity != null : !((Object)this$fuelTankCapacity).equals(other$fuelTankCapacity)) {
            return false;
        }
        Boolean this$disableSleeperBerth = this.getDisableSleeperBerth();
        Boolean other$disableSleeperBerth = other.getDisableSleeperBerth();
        if (this$disableSleeperBerth == null ? other$disableSleeperBerth != null : !((Object)this$disableSleeperBerth).equals(other$disableSleeperBerth)) {
            return false;
        }
        Short this$parameterVersionOnDevice = this.getParameterVersionOnDevice();
        Short other$parameterVersionOnDevice = other.getParameterVersionOnDevice();
        if (this$parameterVersionOnDevice == null ? other$parameterVersionOnDevice != null : !((Object)this$parameterVersionOnDevice).equals(other$parameterVersionOnDevice)) {
            return false;
        }
        List<Group> this$autoGroups = this.getAutoGroups();
        List<Group> other$autoGroups = other.getAutoGroups();
        if (this$autoGroups == null ? other$autoGroups != null : !((Object)this$autoGroups).equals(other$autoGroups)) {
            return false;
        }
        List<CustomParameter> this$customParameters = this.getCustomParameters();
        List<CustomParameter> other$customParameters = other.getCustomParameters();
        if (this$customParameters == null ? other$customParameters != null : !((Object)this$customParameters).equals(other$customParameters)) {
            return false;
        }
        EngineType this$engineType = this.getEngineType();
        EngineType other$engineType = other.getEngineType();
        if (this$engineType == null ? other$engineType != null : !((Object)this$engineType).equals(other$engineType)) {
            return false;
        }
        String this$engineVehicleIdentificationNumber = this.getEngineVehicleIdentificationNumber();
        String other$engineVehicleIdentificationNumber = other.getEngineVehicleIdentificationNumber();
        if (this$engineVehicleIdentificationNumber == null ? other$engineVehicleIdentificationNumber != null : !this$engineVehicleIdentificationNumber.equals(other$engineVehicleIdentificationNumber)) {
            return false;
        }
        String this$licensePlate = this.getLicensePlate();
        String other$licensePlate = other.getLicensePlate();
        if (this$licensePlate == null ? other$licensePlate != null : !this$licensePlate.equals(other$licensePlate)) {
            return false;
        }
        String this$licenseState = this.getLicenseState();
        String other$licenseState = other.getLicenseState();
        if (this$licenseState == null ? other$licenseState != null : !this$licenseState.equals(other$licenseState)) {
            return false;
        }
        String this$vehicleIdentificationNumber = this.getVehicleIdentificationNumber();
        String other$vehicleIdentificationNumber = other.getVehicleIdentificationNumber();
        if (this$vehicleIdentificationNumber == null ? other$vehicleIdentificationNumber != null : !this$vehicleIdentificationNumber.equals(other$vehicleIdentificationNumber)) {
            return false;
        }
        GoTalkLanguage this$goTalkLanguage = this.getGoTalkLanguage();
        GoTalkLanguage other$goTalkLanguage = other.getGoTalkLanguage();
        if (this$goTalkLanguage == null ? other$goTalkLanguage != null : !this$goTalkLanguage.equals(other$goTalkLanguage)) {
            return false;
        }
        HosOption this$autoHos = this.getAutoHos();
        HosOption other$autoHos = other.getAutoHos();
        if (this$autoHos == null ? other$autoHos != null : !this$autoHos.equals(other$autoHos)) {
            return false;
        }
        List<WifiUsageTier> this$wifiHotspotLimits = this.getWifiHotspotLimits();
        List<WifiUsageTier> other$wifiHotspotLimits = other.getWifiHotspotLimits();
        return !(this$wifiHotspotLimits == null ? other$wifiHotspotLimits != null : !((Object)this$wifiHotspotLimits).equals(other$wifiHotspotLimits));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GoDevice;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDisableBuzzer() ? 79 : 97);
        result = result * 59 + (this.isEnableBeepOnIdle() ? 79 : 97);
        result = result * 59 + (this.isEnableMustReprogram() ? 79 : 97);
        result = result * 59 + (this.isEnableSpeedWarning() ? 79 : 97);
        result = result * 59 + (this.isEnsureHotStart() ? 79 : 97);
        Integer $gpsOffDelay = this.getGpsOffDelay();
        result = result * 59 + ($gpsOffDelay == null ? 43 : ((Object)$gpsOffDelay).hashCode());
        Integer $idleMinutes = this.getIdleMinutes();
        result = result * 59 + ($idleMinutes == null ? 43 : ((Object)$idleMinutes).hashCode());
        Boolean $isSpeedIndicator = this.getIsSpeedIndicator();
        result = result * 59 + ($isSpeedIndicator == null ? 43 : ((Object)$isSpeedIndicator).hashCode());
        Short $major = this.getMajor();
        result = result * 59 + ($major == null ? 43 : ((Object)$major).hashCode());
        Double $minAccidentSpeed = this.getMinAccidentSpeed();
        result = result * 59 + ($minAccidentSpeed == null ? 43 : ((Object)$minAccidentSpeed).hashCode());
        Short $minor = this.getMinor();
        result = result * 59 + ($minor == null ? 43 : ((Object)$minor).hashCode());
        Integer $parameterVersion = this.getParameterVersion();
        result = result * 59 + ($parameterVersion == null ? 43 : ((Object)$parameterVersion).hashCode());
        Boolean $pinDevice = this.getPinDevice();
        result = result * 59 + ($pinDevice == null ? 43 : ((Object)$pinDevice).hashCode());
        Double $speedingOff = this.getSpeedingOff();
        result = result * 59 + ($speedingOff == null ? 43 : ((Object)$speedingOff).hashCode());
        Double $speedingOn = this.getSpeedingOn();
        result = result * 59 + ($speedingOn == null ? 43 : ((Object)$speedingOn).hashCode());
        Double $fuelTankCapacity = this.getFuelTankCapacity();
        result = result * 59 + ($fuelTankCapacity == null ? 43 : ((Object)$fuelTankCapacity).hashCode());
        Boolean $disableSleeperBerth = this.getDisableSleeperBerth();
        result = result * 59 + ($disableSleeperBerth == null ? 43 : ((Object)$disableSleeperBerth).hashCode());
        Short $parameterVersionOnDevice = this.getParameterVersionOnDevice();
        result = result * 59 + ($parameterVersionOnDevice == null ? 43 : ((Object)$parameterVersionOnDevice).hashCode());
        List<Group> $autoGroups = this.getAutoGroups();
        result = result * 59 + ($autoGroups == null ? 43 : ((Object)$autoGroups).hashCode());
        List<CustomParameter> $customParameters = this.getCustomParameters();
        result = result * 59 + ($customParameters == null ? 43 : ((Object)$customParameters).hashCode());
        EngineType $engineType = this.getEngineType();
        result = result * 59 + ($engineType == null ? 43 : ((Object)$engineType).hashCode());
        String $engineVehicleIdentificationNumber = this.getEngineVehicleIdentificationNumber();
        result = result * 59 + ($engineVehicleIdentificationNumber == null ? 43 : $engineVehicleIdentificationNumber.hashCode());
        String $licensePlate = this.getLicensePlate();
        result = result * 59 + ($licensePlate == null ? 43 : $licensePlate.hashCode());
        String $licenseState = this.getLicenseState();
        result = result * 59 + ($licenseState == null ? 43 : $licenseState.hashCode());
        String $vehicleIdentificationNumber = this.getVehicleIdentificationNumber();
        result = result * 59 + ($vehicleIdentificationNumber == null ? 43 : $vehicleIdentificationNumber.hashCode());
        GoTalkLanguage $goTalkLanguage = this.getGoTalkLanguage();
        result = result * 59 + ($goTalkLanguage == null ? 43 : $goTalkLanguage.hashCode());
        HosOption $autoHos = this.getAutoHos();
        result = result * 59 + ($autoHos == null ? 43 : $autoHos.hashCode());
        List<WifiUsageTier> $wifiHotspotLimits = this.getWifiHotspotLimits();
        result = result * 59 + ($wifiHotspotLimits == null ? 43 : ((Object)$wifiHotspotLimits).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "GoDevice(super=" + super.toString() + ", autoGroups=" + this.getAutoGroups() + ", customParameters=" + this.getCustomParameters() + ", disableBuzzer=" + this.isDisableBuzzer() + ", enableBeepOnIdle=" + this.isEnableBeepOnIdle() + ", enableMustReprogram=" + this.isEnableMustReprogram() + ", enableSpeedWarning=" + this.isEnableSpeedWarning() + ", engineType=" + this.getEngineType() + ", engineVehicleIdentificationNumber=" + this.getEngineVehicleIdentificationNumber() + ", ensureHotStart=" + this.isEnsureHotStart() + ", gpsOffDelay=" + this.getGpsOffDelay() + ", idleMinutes=" + this.getIdleMinutes() + ", isSpeedIndicator=" + this.getIsSpeedIndicator() + ", licensePlate=" + this.getLicensePlate() + ", licenseState=" + this.getLicenseState() + ", major=" + this.getMajor() + ", minAccidentSpeed=" + this.getMinAccidentSpeed() + ", minor=" + this.getMinor() + ", parameterVersion=" + this.getParameterVersion() + ", pinDevice=" + this.getPinDevice() + ", speedingOff=" + this.getSpeedingOff() + ", speedingOn=" + this.getSpeedingOn() + ", vehicleIdentificationNumber=" + this.getVehicleIdentificationNumber() + ", goTalkLanguage=" + this.getGoTalkLanguage() + ", fuelTankCapacity=" + this.getFuelTankCapacity() + ", disableSleeperBerth=" + this.getDisableSleeperBerth() + ", autoHos=" + this.getAutoHos() + ", wifiHotspotLimits=" + this.getWifiHotspotLimits() + ", parameterVersionOnDevice=" + this.getParameterVersionOnDevice() + ")";
    }

    @Generated
    public GoDevice() {
    }

    @Generated
    public static abstract class GoDeviceBuilder<C extends GoDevice, B extends GoDeviceBuilder<C, B>>
    extends Device.DeviceBuilder<C, B> {
        @Generated
        private List<Group> autoGroups;
        @Generated
        private List<CustomParameter> customParameters;
        @Generated
        private boolean disableBuzzer;
        @Generated
        private boolean enableBeepOnIdle;
        @Generated
        private boolean enableMustReprogram;
        @Generated
        private boolean enableSpeedWarning;
        @Generated
        private EngineType engineType;
        @Generated
        private String engineVehicleIdentificationNumber;
        @Generated
        private boolean ensureHotStart;
        @Generated
        private Integer gpsOffDelay;
        @Generated
        private Integer idleMinutes;
        @Generated
        private Boolean isSpeedIndicator;
        @Generated
        private String licensePlate;
        @Generated
        private String licenseState;
        @Generated
        private Short major;
        @Generated
        private Double minAccidentSpeed;
        @Generated
        private Short minor;
        @Generated
        private Integer parameterVersion;
        @Generated
        private Boolean pinDevice;
        @Generated
        private Double speedingOff;
        @Generated
        private Double speedingOn;
        @Generated
        private String vehicleIdentificationNumber;
        @Generated
        private GoTalkLanguage goTalkLanguage;
        @Generated
        private Double fuelTankCapacity;
        @Generated
        private Boolean disableSleeperBerth;
        @Generated
        private HosOption autoHos;
        @Generated
        private List<WifiUsageTier> wifiHotspotLimits;
        @Generated
        private Short parameterVersionOnDevice;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B autoGroups(List<Group> autoGroups) {
            this.autoGroups = autoGroups;
            return (B)this.self();
        }

        @Generated
        public B customParameters(List<CustomParameter> customParameters) {
            this.customParameters = customParameters;
            return (B)this.self();
        }

        @Generated
        public B disableBuzzer(boolean disableBuzzer) {
            this.disableBuzzer = disableBuzzer;
            return (B)this.self();
        }

        @Generated
        public B enableBeepOnIdle(boolean enableBeepOnIdle) {
            this.enableBeepOnIdle = enableBeepOnIdle;
            return (B)this.self();
        }

        @Generated
        public B enableMustReprogram(boolean enableMustReprogram) {
            this.enableMustReprogram = enableMustReprogram;
            return (B)this.self();
        }

        @Generated
        public B enableSpeedWarning(boolean enableSpeedWarning) {
            this.enableSpeedWarning = enableSpeedWarning;
            return (B)this.self();
        }

        @Generated
        public B engineType(EngineType engineType) {
            this.engineType = engineType;
            return (B)this.self();
        }

        @Generated
        public B engineVehicleIdentificationNumber(String engineVehicleIdentificationNumber) {
            this.engineVehicleIdentificationNumber = engineVehicleIdentificationNumber;
            return (B)this.self();
        }

        @Generated
        public B ensureHotStart(boolean ensureHotStart) {
            this.ensureHotStart = ensureHotStart;
            return (B)this.self();
        }

        @Generated
        public B gpsOffDelay(Integer gpsOffDelay) {
            this.gpsOffDelay = gpsOffDelay;
            return (B)this.self();
        }

        @Generated
        public B idleMinutes(Integer idleMinutes) {
            this.idleMinutes = idleMinutes;
            return (B)this.self();
        }

        @Generated
        public B isSpeedIndicator(Boolean isSpeedIndicator) {
            this.isSpeedIndicator = isSpeedIndicator;
            return (B)this.self();
        }

        @Generated
        public B licensePlate(String licensePlate) {
            this.licensePlate = licensePlate;
            return (B)this.self();
        }

        @Generated
        public B licenseState(String licenseState) {
            this.licenseState = licenseState;
            return (B)this.self();
        }

        @Generated
        public B major(Short major) {
            this.major = major;
            return (B)this.self();
        }

        @Generated
        public B minAccidentSpeed(Double minAccidentSpeed) {
            this.minAccidentSpeed = minAccidentSpeed;
            return (B)this.self();
        }

        @Generated
        public B minor(Short minor) {
            this.minor = minor;
            return (B)this.self();
        }

        @Generated
        public B parameterVersion(Integer parameterVersion) {
            this.parameterVersion = parameterVersion;
            return (B)this.self();
        }

        @Generated
        public B pinDevice(Boolean pinDevice) {
            this.pinDevice = pinDevice;
            return (B)this.self();
        }

        @Generated
        public B speedingOff(Double speedingOff) {
            this.speedingOff = speedingOff;
            return (B)this.self();
        }

        @Generated
        public B speedingOn(Double speedingOn) {
            this.speedingOn = speedingOn;
            return (B)this.self();
        }

        @Generated
        public B vehicleIdentificationNumber(String vehicleIdentificationNumber) {
            this.vehicleIdentificationNumber = vehicleIdentificationNumber;
            return (B)this.self();
        }

        @Generated
        public B goTalkLanguage(GoTalkLanguage goTalkLanguage) {
            this.goTalkLanguage = goTalkLanguage;
            return (B)this.self();
        }

        @Generated
        public B fuelTankCapacity(Double fuelTankCapacity) {
            this.fuelTankCapacity = fuelTankCapacity;
            return (B)this.self();
        }

        @Generated
        public B disableSleeperBerth(Boolean disableSleeperBerth) {
            this.disableSleeperBerth = disableSleeperBerth;
            return (B)this.self();
        }

        @Generated
        public B autoHos(HosOption autoHos) {
            this.autoHos = autoHos;
            return (B)this.self();
        }

        @Generated
        public B wifiHotspotLimits(List<WifiUsageTier> wifiHotspotLimits) {
            this.wifiHotspotLimits = wifiHotspotLimits;
            return (B)this.self();
        }

        @Generated
        public B parameterVersionOnDevice(Short parameterVersionOnDevice) {
            this.parameterVersionOnDevice = parameterVersionOnDevice;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "GoDevice.GoDeviceBuilder(super=" + super.toString() + ", autoGroups=" + this.autoGroups + ", customParameters=" + this.customParameters + ", disableBuzzer=" + this.disableBuzzer + ", enableBeepOnIdle=" + this.enableBeepOnIdle + ", enableMustReprogram=" + this.enableMustReprogram + ", enableSpeedWarning=" + this.enableSpeedWarning + ", engineType=" + this.engineType + ", engineVehicleIdentificationNumber=" + this.engineVehicleIdentificationNumber + ", ensureHotStart=" + this.ensureHotStart + ", gpsOffDelay=" + this.gpsOffDelay + ", idleMinutes=" + this.idleMinutes + ", isSpeedIndicator=" + this.isSpeedIndicator + ", licensePlate=" + this.licensePlate + ", licenseState=" + this.licenseState + ", major=" + this.major + ", minAccidentSpeed=" + this.minAccidentSpeed + ", minor=" + this.minor + ", parameterVersion=" + this.parameterVersion + ", pinDevice=" + this.pinDevice + ", speedingOff=" + this.speedingOff + ", speedingOn=" + this.speedingOn + ", vehicleIdentificationNumber=" + this.vehicleIdentificationNumber + ", goTalkLanguage=" + this.goTalkLanguage + ", fuelTankCapacity=" + this.fuelTankCapacity + ", disableSleeperBerth=" + this.disableSleeperBerth + ", autoHos=" + this.autoHos + ", wifiHotspotLimits=" + this.wifiHotspotLimits + ", parameterVersionOnDevice=" + this.parameterVersionOnDevice + ")";
        }
    }
}

