/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.exceptionevent;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.diagnostic.Diagnostic;
import com.geotab.model.entity.exceptionevent.NoExceptionEvent;
import com.geotab.model.entity.exceptionevent.state.ExceptionEventState;
import com.geotab.model.entity.rule.Rule;
import com.geotab.model.entity.user.User;
import com.geotab.model.serialization.DriverEmbeddedSerializer;
import com.geotab.util.Util;
import java.time.Duration;
import java.time.LocalDateTime;
import lombok.Generated;

public class ExceptionEvent
extends EntityWithVersion {
    private LocalDateTime activeFrom;
    private LocalDateTime activeTo;
    private Device device;
    private Float distance;
    private Duration duration;
    private Rule rule;
    private Diagnostic diagnostic;
    @JsonSerialize(using=DriverEmbeddedSerializer.class)
    private User driver;
    private ExceptionEventState state;
    private LocalDateTime lastModifiedDateTime;

    public static ExceptionEvent fromSystem(String id) {
        if (Util.isEmpty(id)) {
            return null;
        }
        if ("NoExceptionEventId".equals(id)) {
            return NoExceptionEvent.getInstance();
        }
        return null;
    }

    @Generated
    protected ExceptionEvent(ExceptionEventBuilder<?, ?> b) {
        super((EntityWithVersion.EntityWithVersionBuilder<?, ?>)b);
        this.activeFrom = ((ExceptionEventBuilder)b).activeFrom;
        this.activeTo = ((ExceptionEventBuilder)b).activeTo;
        this.device = ((ExceptionEventBuilder)b).device;
        this.distance = ((ExceptionEventBuilder)b).distance;
        this.duration = ((ExceptionEventBuilder)b).duration;
        this.rule = ((ExceptionEventBuilder)b).rule;
        this.diagnostic = ((ExceptionEventBuilder)b).diagnostic;
        this.driver = ((ExceptionEventBuilder)b).driver;
        this.state = ((ExceptionEventBuilder)b).state;
        this.lastModifiedDateTime = ((ExceptionEventBuilder)b).lastModifiedDateTime;
    }

    @Generated
    public static ExceptionEventBuilder<?, ?> builder() {
        return new ExceptionEventBuilderImpl();
    }

    @Generated
    public LocalDateTime getActiveFrom() {
        return this.activeFrom;
    }

    @Generated
    public LocalDateTime getActiveTo() {
        return this.activeTo;
    }

    @Generated
    public Device getDevice() {
        return this.device;
    }

    @Generated
    public Float getDistance() {
        return this.distance;
    }

    @Generated
    public Duration getDuration() {
        return this.duration;
    }

    @Generated
    public Rule getRule() {
        return this.rule;
    }

    @Generated
    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    @Generated
    public User getDriver() {
        return this.driver;
    }

    @Generated
    public ExceptionEventState getState() {
        return this.state;
    }

    @Generated
    public LocalDateTime getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    @Generated
    public ExceptionEvent setActiveFrom(LocalDateTime activeFrom) {
        this.activeFrom = activeFrom;
        return this;
    }

    @Generated
    public ExceptionEvent setActiveTo(LocalDateTime activeTo) {
        this.activeTo = activeTo;
        return this;
    }

    @Generated
    public ExceptionEvent setDevice(Device device) {
        this.device = device;
        return this;
    }

    @Generated
    public ExceptionEvent setDistance(Float distance) {
        this.distance = distance;
        return this;
    }

    @Generated
    public ExceptionEvent setDuration(Duration duration) {
        this.duration = duration;
        return this;
    }

    @Generated
    public ExceptionEvent setRule(Rule rule) {
        this.rule = rule;
        return this;
    }

    @Generated
    public ExceptionEvent setDiagnostic(Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
        return this;
    }

    @Generated
    public ExceptionEvent setDriver(User driver) {
        this.driver = driver;
        return this;
    }

    @Generated
    public ExceptionEvent setState(ExceptionEventState state) {
        this.state = state;
        return this;
    }

    @Generated
    public ExceptionEvent setLastModifiedDateTime(LocalDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExceptionEvent)) {
            return false;
        }
        ExceptionEvent other = (ExceptionEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$distance = this.getDistance();
        Float other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        LocalDateTime this$activeFrom = this.getActiveFrom();
        LocalDateTime other$activeFrom = other.getActiveFrom();
        if (this$activeFrom == null ? other$activeFrom != null : !((Object)this$activeFrom).equals(other$activeFrom)) {
            return false;
        }
        LocalDateTime this$activeTo = this.getActiveTo();
        LocalDateTime other$activeTo = other.getActiveTo();
        if (this$activeTo == null ? other$activeTo != null : !((Object)this$activeTo).equals(other$activeTo)) {
            return false;
        }
        Device this$device = this.getDevice();
        Device other$device = other.getDevice();
        if (this$device == null ? other$device != null : !((Object)this$device).equals(other$device)) {
            return false;
        }
        Duration this$duration = this.getDuration();
        Duration other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Rule this$rule = this.getRule();
        Rule other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !((Object)this$rule).equals(other$rule)) {
            return false;
        }
        Diagnostic this$diagnostic = this.getDiagnostic();
        Diagnostic other$diagnostic = other.getDiagnostic();
        if (this$diagnostic == null ? other$diagnostic != null : !((Object)this$diagnostic).equals(other$diagnostic)) {
            return false;
        }
        User this$driver = this.getDriver();
        User other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !((Object)this$driver).equals(other$driver)) {
            return false;
        }
        ExceptionEventState this$state = this.getState();
        ExceptionEventState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        LocalDateTime this$lastModifiedDateTime = this.getLastModifiedDateTime();
        LocalDateTime other$lastModifiedDateTime = other.getLastModifiedDateTime();
        return !(this$lastModifiedDateTime == null ? other$lastModifiedDateTime != null : !((Object)this$lastModifiedDateTime).equals(other$lastModifiedDateTime));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExceptionEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        LocalDateTime $activeFrom = this.getActiveFrom();
        result = result * 59 + ($activeFrom == null ? 43 : ((Object)$activeFrom).hashCode());
        LocalDateTime $activeTo = this.getActiveTo();
        result = result * 59 + ($activeTo == null ? 43 : ((Object)$activeTo).hashCode());
        Device $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : ((Object)$device).hashCode());
        Duration $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Rule $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : ((Object)$rule).hashCode());
        Diagnostic $diagnostic = this.getDiagnostic();
        result = result * 59 + ($diagnostic == null ? 43 : ((Object)$diagnostic).hashCode());
        User $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : ((Object)$driver).hashCode());
        ExceptionEventState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        LocalDateTime $lastModifiedDateTime = this.getLastModifiedDateTime();
        result = result * 59 + ($lastModifiedDateTime == null ? 43 : ((Object)$lastModifiedDateTime).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ExceptionEvent(super=" + super.toString() + ", activeFrom=" + this.getActiveFrom() + ", activeTo=" + this.getActiveTo() + ", device=" + this.getDevice() + ", distance=" + this.getDistance() + ", duration=" + this.getDuration() + ", rule=" + this.getRule() + ", diagnostic=" + this.getDiagnostic() + ", driver=" + this.getDriver() + ", state=" + this.getState() + ", lastModifiedDateTime=" + this.getLastModifiedDateTime() + ")";
    }

    @Generated
    public ExceptionEvent() {
    }

    @Generated
    private static final class ExceptionEventBuilderImpl
    extends ExceptionEventBuilder<ExceptionEvent, ExceptionEventBuilderImpl> {
        @Generated
        private ExceptionEventBuilderImpl() {
        }

        @Override
        @Generated
        protected ExceptionEventBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExceptionEvent build() {
            return new ExceptionEvent(this);
        }
    }

    @Generated
    public static abstract class ExceptionEventBuilder<C extends ExceptionEvent, B extends ExceptionEventBuilder<C, B>>
    extends EntityWithVersion.EntityWithVersionBuilder<C, B> {
        @Generated
        private LocalDateTime activeFrom;
        @Generated
        private LocalDateTime activeTo;
        @Generated
        private Device device;
        @Generated
        private Float distance;
        @Generated
        private Duration duration;
        @Generated
        private Rule rule;
        @Generated
        private Diagnostic diagnostic;
        @Generated
        private User driver;
        @Generated
        private ExceptionEventState state;
        @Generated
        private LocalDateTime lastModifiedDateTime;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B activeFrom(LocalDateTime activeFrom) {
            this.activeFrom = activeFrom;
            return (B)this.self();
        }

        @Generated
        public B activeTo(LocalDateTime activeTo) {
            this.activeTo = activeTo;
            return (B)this.self();
        }

        @Generated
        public B device(Device device) {
            this.device = device;
            return (B)this.self();
        }

        @Generated
        public B distance(Float distance) {
            this.distance = distance;
            return (B)this.self();
        }

        @Generated
        public B duration(Duration duration) {
            this.duration = duration;
            return (B)this.self();
        }

        @Generated
        public B rule(Rule rule) {
            this.rule = rule;
            return (B)this.self();
        }

        @Generated
        public B diagnostic(Diagnostic diagnostic) {
            this.diagnostic = diagnostic;
            return (B)this.self();
        }

        @Generated
        public B driver(User driver) {
            this.driver = driver;
            return (B)this.self();
        }

        @Generated
        public B state(ExceptionEventState state) {
            this.state = state;
            return (B)this.self();
        }

        @Generated
        public B lastModifiedDateTime(LocalDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ExceptionEvent.ExceptionEventBuilder(super=" + super.toString() + ", activeFrom=" + this.activeFrom + ", activeTo=" + this.activeTo + ", device=" + this.device + ", distance=" + this.distance + ", duration=" + this.duration + ", rule=" + this.rule + ", diagnostic=" + this.diagnostic + ", driver=" + this.driver + ", state=" + this.state + ", lastModifiedDateTime=" + this.lastModifiedDateTime + ")";
        }
    }
}

