/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.tachograph.files;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.entitysettings.TachographFileFormat;
import com.geotab.model.entity.user.Driver;
import com.geotab.model.serialization.ByteArrayDeserializer;
import com.geotab.model.serialization.ByteArraySerializer;
import java.time.LocalDateTime;
import java.util.Arrays;
import lombok.Generated;

public class TachographDataFile
extends EntityWithVersion {
    private Driver driver;
    private Device device;
    @JsonDeserialize(using=ByteArrayDeserializer.class)
    @JsonSerialize(using=ByteArraySerializer.class)
    private Byte[] binaryData;
    private int origin;
    private String originDescription;
    private LocalDateTime dateTime;
    private LocalDateTime uploadDateTime;
    private LocalDateTime timestamp;
    private LocalDateTime timestampStart;
    private LocalDateTime timestampEnd;
    private String fileName;
    private String summary;
    private int signature;
    private String fileNameTgd;
    private String fileNameDdd;
    private String fileNameV1B;
    private String warnings;
    private String errors;
    private int processingStatus;
    private String lockGaps;
    private Boolean archived;

    public TachographDataFile(TachographDataFile value) {
        this(value.getId(), value.getDriver(), value.getDevice(), value.getBinaryData(), value.getOrigin(), value.getOriginDescription(), value.getDateTime(), value.getTimestamp(), value.getTimestampStart(), value.getTimestampEnd(), value.getFileName(), value.getSummary(), value.getSignature(), value.getFileNameTgd(), value.getFileNameDdd(), value.getFileNameV1B(), value.getWarnings(), value.getErrors(), value.getProcessingStatus(), value.getLockGaps(), value.getArchived());
    }

    public TachographDataFile(Id id, Driver driver, Device device, Byte[] binaryData, int origin, String originDescription, LocalDateTime dateTime, LocalDateTime timestamp, LocalDateTime timestampStart, LocalDateTime timestampEnd, String fileName, String summary, int signature, String fileNameTgd, String fileNameDdd, String fileNameV1B, String warnings, String errors, int processingStatus, String lockGaps, Boolean archived) {
        this.setId(id);
        this.driver = driver;
        this.device = device;
        this.binaryData = binaryData;
        this.origin = origin;
        this.originDescription = originDescription;
        this.dateTime = dateTime;
        this.timestamp = timestamp;
        this.timestampStart = timestampStart;
        this.timestampEnd = timestampEnd;
        this.fileName = fileName;
        this.summary = summary;
        this.signature = signature;
        this.fileNameTgd = fileNameTgd;
        this.fileNameDdd = fileNameDdd;
        this.fileNameV1B = fileNameV1B;
        this.warnings = warnings;
        this.errors = errors;
        this.processingStatus = processingStatus;
        this.lockGaps = lockGaps;
        this.archived = archived;
    }

    public String getFileNameFromFileFormatOrDefault(TachographFileFormat tachographFileFormat) {
        switch (tachographFileFormat) {
            case Ddd: {
                return this.fileNameDdd;
            }
            case V1b: {
                return this.fileNameV1B;
            }
        }
        return this.fileNameTgd;
    }

    @Generated
    protected TachographDataFile(TachographDataFileBuilder<?, ?> b) {
        super((EntityWithVersion.EntityWithVersionBuilder<?, ?>)b);
        this.driver = ((TachographDataFileBuilder)b).driver;
        this.device = ((TachographDataFileBuilder)b).device;
        this.binaryData = ((TachographDataFileBuilder)b).binaryData;
        this.origin = ((TachographDataFileBuilder)b).origin;
        this.originDescription = ((TachographDataFileBuilder)b).originDescription;
        this.dateTime = ((TachographDataFileBuilder)b).dateTime;
        this.uploadDateTime = ((TachographDataFileBuilder)b).uploadDateTime;
        this.timestamp = ((TachographDataFileBuilder)b).timestamp;
        this.timestampStart = ((TachographDataFileBuilder)b).timestampStart;
        this.timestampEnd = ((TachographDataFileBuilder)b).timestampEnd;
        this.fileName = ((TachographDataFileBuilder)b).fileName;
        this.summary = ((TachographDataFileBuilder)b).summary;
        this.signature = ((TachographDataFileBuilder)b).signature;
        this.fileNameTgd = ((TachographDataFileBuilder)b).fileNameTgd;
        this.fileNameDdd = ((TachographDataFileBuilder)b).fileNameDdd;
        this.fileNameV1B = ((TachographDataFileBuilder)b).fileNameV1B;
        this.warnings = ((TachographDataFileBuilder)b).warnings;
        this.errors = ((TachographDataFileBuilder)b).errors;
        this.processingStatus = ((TachographDataFileBuilder)b).processingStatus;
        this.lockGaps = ((TachographDataFileBuilder)b).lockGaps;
        this.archived = ((TachographDataFileBuilder)b).archived;
    }

    @Generated
    public static TachographDataFileBuilder<?, ?> builder() {
        return new TachographDataFileBuilderImpl();
    }

    @Generated
    public Driver getDriver() {
        return this.driver;
    }

    @Generated
    public Device getDevice() {
        return this.device;
    }

    @Generated
    public Byte[] getBinaryData() {
        return this.binaryData;
    }

    @Generated
    public int getOrigin() {
        return this.origin;
    }

    @Generated
    public String getOriginDescription() {
        return this.originDescription;
    }

    @Generated
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @Generated
    public LocalDateTime getUploadDateTime() {
        return this.uploadDateTime;
    }

    @Generated
    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public LocalDateTime getTimestampStart() {
        return this.timestampStart;
    }

    @Generated
    public LocalDateTime getTimestampEnd() {
        return this.timestampEnd;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getSummary() {
        return this.summary;
    }

    @Generated
    public int getSignature() {
        return this.signature;
    }

    @Generated
    public String getFileNameTgd() {
        return this.fileNameTgd;
    }

    @Generated
    public String getFileNameDdd() {
        return this.fileNameDdd;
    }

    @Generated
    public String getFileNameV1B() {
        return this.fileNameV1B;
    }

    @Generated
    public String getWarnings() {
        return this.warnings;
    }

    @Generated
    public String getErrors() {
        return this.errors;
    }

    @Generated
    public int getProcessingStatus() {
        return this.processingStatus;
    }

    @Generated
    public String getLockGaps() {
        return this.lockGaps;
    }

    @Generated
    public Boolean getArchived() {
        return this.archived;
    }

    @Generated
    public TachographDataFile setDriver(Driver driver) {
        this.driver = driver;
        return this;
    }

    @Generated
    public TachographDataFile setDevice(Device device) {
        this.device = device;
        return this;
    }

    @JsonDeserialize(using=ByteArrayDeserializer.class)
    @Generated
    public TachographDataFile setBinaryData(Byte[] binaryData) {
        this.binaryData = binaryData;
        return this;
    }

    @Generated
    public TachographDataFile setOrigin(int origin) {
        this.origin = origin;
        return this;
    }

    @Generated
    public TachographDataFile setOriginDescription(String originDescription) {
        this.originDescription = originDescription;
        return this;
    }

    @Generated
    public TachographDataFile setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    @Generated
    public TachographDataFile setUploadDateTime(LocalDateTime uploadDateTime) {
        this.uploadDateTime = uploadDateTime;
        return this;
    }

    @Generated
    public TachographDataFile setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Generated
    public TachographDataFile setTimestampStart(LocalDateTime timestampStart) {
        this.timestampStart = timestampStart;
        return this;
    }

    @Generated
    public TachographDataFile setTimestampEnd(LocalDateTime timestampEnd) {
        this.timestampEnd = timestampEnd;
        return this;
    }

    @Generated
    public TachographDataFile setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Generated
    public TachographDataFile setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    @Generated
    public TachographDataFile setSignature(int signature) {
        this.signature = signature;
        return this;
    }

    @Generated
    public TachographDataFile setFileNameTgd(String fileNameTgd) {
        this.fileNameTgd = fileNameTgd;
        return this;
    }

    @Generated
    public TachographDataFile setFileNameDdd(String fileNameDdd) {
        this.fileNameDdd = fileNameDdd;
        return this;
    }

    @Generated
    public TachographDataFile setFileNameV1B(String fileNameV1B) {
        this.fileNameV1B = fileNameV1B;
        return this;
    }

    @Generated
    public TachographDataFile setWarnings(String warnings) {
        this.warnings = warnings;
        return this;
    }

    @Generated
    public TachographDataFile setErrors(String errors) {
        this.errors = errors;
        return this;
    }

    @Generated
    public TachographDataFile setProcessingStatus(int processingStatus) {
        this.processingStatus = processingStatus;
        return this;
    }

    @Generated
    public TachographDataFile setLockGaps(String lockGaps) {
        this.lockGaps = lockGaps;
        return this;
    }

    @Generated
    public TachographDataFile setArchived(Boolean archived) {
        this.archived = archived;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TachographDataFile)) {
            return false;
        }
        TachographDataFile other = (TachographDataFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getOrigin() != other.getOrigin()) {
            return false;
        }
        if (this.getSignature() != other.getSignature()) {
            return false;
        }
        if (this.getProcessingStatus() != other.getProcessingStatus()) {
            return false;
        }
        Boolean this$archived = this.getArchived();
        Boolean other$archived = other.getArchived();
        if (this$archived == null ? other$archived != null : !((Object)this$archived).equals(other$archived)) {
            return false;
        }
        Driver this$driver = this.getDriver();
        Driver other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !((Object)this$driver).equals(other$driver)) {
            return false;
        }
        Device this$device = this.getDevice();
        Device other$device = other.getDevice();
        if (this$device == null ? other$device != null : !((Object)this$device).equals(other$device)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBinaryData(), other.getBinaryData())) {
            return false;
        }
        String this$originDescription = this.getOriginDescription();
        String other$originDescription = other.getOriginDescription();
        if (this$originDescription == null ? other$originDescription != null : !this$originDescription.equals(other$originDescription)) {
            return false;
        }
        LocalDateTime this$dateTime = this.getDateTime();
        LocalDateTime other$dateTime = other.getDateTime();
        if (this$dateTime == null ? other$dateTime != null : !((Object)this$dateTime).equals(other$dateTime)) {
            return false;
        }
        LocalDateTime this$uploadDateTime = this.getUploadDateTime();
        LocalDateTime other$uploadDateTime = other.getUploadDateTime();
        if (this$uploadDateTime == null ? other$uploadDateTime != null : !((Object)this$uploadDateTime).equals(other$uploadDateTime)) {
            return false;
        }
        LocalDateTime this$timestamp = this.getTimestamp();
        LocalDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        LocalDateTime this$timestampStart = this.getTimestampStart();
        LocalDateTime other$timestampStart = other.getTimestampStart();
        if (this$timestampStart == null ? other$timestampStart != null : !((Object)this$timestampStart).equals(other$timestampStart)) {
            return false;
        }
        LocalDateTime this$timestampEnd = this.getTimestampEnd();
        LocalDateTime other$timestampEnd = other.getTimestampEnd();
        if (this$timestampEnd == null ? other$timestampEnd != null : !((Object)this$timestampEnd).equals(other$timestampEnd)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        String this$fileNameTgd = this.getFileNameTgd();
        String other$fileNameTgd = other.getFileNameTgd();
        if (this$fileNameTgd == null ? other$fileNameTgd != null : !this$fileNameTgd.equals(other$fileNameTgd)) {
            return false;
        }
        String this$fileNameDdd = this.getFileNameDdd();
        String other$fileNameDdd = other.getFileNameDdd();
        if (this$fileNameDdd == null ? other$fileNameDdd != null : !this$fileNameDdd.equals(other$fileNameDdd)) {
            return false;
        }
        String this$fileNameV1B = this.getFileNameV1B();
        String other$fileNameV1B = other.getFileNameV1B();
        if (this$fileNameV1B == null ? other$fileNameV1B != null : !this$fileNameV1B.equals(other$fileNameV1B)) {
            return false;
        }
        String this$warnings = this.getWarnings();
        String other$warnings = other.getWarnings();
        if (this$warnings == null ? other$warnings != null : !this$warnings.equals(other$warnings)) {
            return false;
        }
        String this$errors = this.getErrors();
        String other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !this$errors.equals(other$errors)) {
            return false;
        }
        String this$lockGaps = this.getLockGaps();
        String other$lockGaps = other.getLockGaps();
        return !(this$lockGaps == null ? other$lockGaps != null : !this$lockGaps.equals(other$lockGaps));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TachographDataFile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getOrigin();
        result = result * 59 + this.getSignature();
        result = result * 59 + this.getProcessingStatus();
        Boolean $archived = this.getArchived();
        result = result * 59 + ($archived == null ? 43 : ((Object)$archived).hashCode());
        Driver $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : ((Object)$driver).hashCode());
        Device $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : ((Object)$device).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getBinaryData());
        String $originDescription = this.getOriginDescription();
        result = result * 59 + ($originDescription == null ? 43 : $originDescription.hashCode());
        LocalDateTime $dateTime = this.getDateTime();
        result = result * 59 + ($dateTime == null ? 43 : ((Object)$dateTime).hashCode());
        LocalDateTime $uploadDateTime = this.getUploadDateTime();
        result = result * 59 + ($uploadDateTime == null ? 43 : ((Object)$uploadDateTime).hashCode());
        LocalDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        LocalDateTime $timestampStart = this.getTimestampStart();
        result = result * 59 + ($timestampStart == null ? 43 : ((Object)$timestampStart).hashCode());
        LocalDateTime $timestampEnd = this.getTimestampEnd();
        result = result * 59 + ($timestampEnd == null ? 43 : ((Object)$timestampEnd).hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        String $fileNameTgd = this.getFileNameTgd();
        result = result * 59 + ($fileNameTgd == null ? 43 : $fileNameTgd.hashCode());
        String $fileNameDdd = this.getFileNameDdd();
        result = result * 59 + ($fileNameDdd == null ? 43 : $fileNameDdd.hashCode());
        String $fileNameV1B = this.getFileNameV1B();
        result = result * 59 + ($fileNameV1B == null ? 43 : $fileNameV1B.hashCode());
        String $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : $warnings.hashCode());
        String $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : $errors.hashCode());
        String $lockGaps = this.getLockGaps();
        result = result * 59 + ($lockGaps == null ? 43 : $lockGaps.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "TachographDataFile(super=" + super.toString() + ", driver=" + this.getDriver() + ", device=" + this.getDevice() + ", binaryData=" + Arrays.deepToString(this.getBinaryData()) + ", origin=" + this.getOrigin() + ", originDescription=" + this.getOriginDescription() + ", dateTime=" + this.getDateTime() + ", uploadDateTime=" + this.getUploadDateTime() + ", timestamp=" + this.getTimestamp() + ", timestampStart=" + this.getTimestampStart() + ", timestampEnd=" + this.getTimestampEnd() + ", fileName=" + this.getFileName() + ", summary=" + this.getSummary() + ", signature=" + this.getSignature() + ", fileNameTgd=" + this.getFileNameTgd() + ", fileNameDdd=" + this.getFileNameDdd() + ", fileNameV1B=" + this.getFileNameV1B() + ", warnings=" + this.getWarnings() + ", errors=" + this.getErrors() + ", processingStatus=" + this.getProcessingStatus() + ", lockGaps=" + this.getLockGaps() + ", archived=" + this.getArchived() + ")";
    }

    @Generated
    public TachographDataFile() {
    }

    @Generated
    private static final class TachographDataFileBuilderImpl
    extends TachographDataFileBuilder<TachographDataFile, TachographDataFileBuilderImpl> {
        @Generated
        private TachographDataFileBuilderImpl() {
        }

        @Override
        @Generated
        protected TachographDataFileBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TachographDataFile build() {
            return new TachographDataFile(this);
        }
    }

    @Generated
    public static abstract class TachographDataFileBuilder<C extends TachographDataFile, B extends TachographDataFileBuilder<C, B>>
    extends EntityWithVersion.EntityWithVersionBuilder<C, B> {
        @Generated
        private Driver driver;
        @Generated
        private Device device;
        @Generated
        private Byte[] binaryData;
        @Generated
        private int origin;
        @Generated
        private String originDescription;
        @Generated
        private LocalDateTime dateTime;
        @Generated
        private LocalDateTime uploadDateTime;
        @Generated
        private LocalDateTime timestamp;
        @Generated
        private LocalDateTime timestampStart;
        @Generated
        private LocalDateTime timestampEnd;
        @Generated
        private String fileName;
        @Generated
        private String summary;
        @Generated
        private int signature;
        @Generated
        private String fileNameTgd;
        @Generated
        private String fileNameDdd;
        @Generated
        private String fileNameV1B;
        @Generated
        private String warnings;
        @Generated
        private String errors;
        @Generated
        private int processingStatus;
        @Generated
        private String lockGaps;
        @Generated
        private Boolean archived;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B driver(Driver driver) {
            this.driver = driver;
            return (B)this.self();
        }

        @Generated
        public B device(Device device) {
            this.device = device;
            return (B)this.self();
        }

        @JsonDeserialize(using=ByteArrayDeserializer.class)
        @Generated
        public B binaryData(Byte[] binaryData) {
            this.binaryData = binaryData;
            return (B)this.self();
        }

        @Generated
        public B origin(int origin) {
            this.origin = origin;
            return (B)this.self();
        }

        @Generated
        public B originDescription(String originDescription) {
            this.originDescription = originDescription;
            return (B)this.self();
        }

        @Generated
        public B dateTime(LocalDateTime dateTime) {
            this.dateTime = dateTime;
            return (B)this.self();
        }

        @Generated
        public B uploadDateTime(LocalDateTime uploadDateTime) {
            this.uploadDateTime = uploadDateTime;
            return (B)this.self();
        }

        @Generated
        public B timestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
            return (B)this.self();
        }

        @Generated
        public B timestampStart(LocalDateTime timestampStart) {
            this.timestampStart = timestampStart;
            return (B)this.self();
        }

        @Generated
        public B timestampEnd(LocalDateTime timestampEnd) {
            this.timestampEnd = timestampEnd;
            return (B)this.self();
        }

        @Generated
        public B fileName(String fileName) {
            this.fileName = fileName;
            return (B)this.self();
        }

        @Generated
        public B summary(String summary) {
            this.summary = summary;
            return (B)this.self();
        }

        @Generated
        public B signature(int signature) {
            this.signature = signature;
            return (B)this.self();
        }

        @Generated
        public B fileNameTgd(String fileNameTgd) {
            this.fileNameTgd = fileNameTgd;
            return (B)this.self();
        }

        @Generated
        public B fileNameDdd(String fileNameDdd) {
            this.fileNameDdd = fileNameDdd;
            return (B)this.self();
        }

        @Generated
        public B fileNameV1B(String fileNameV1B) {
            this.fileNameV1B = fileNameV1B;
            return (B)this.self();
        }

        @Generated
        public B warnings(String warnings) {
            this.warnings = warnings;
            return (B)this.self();
        }

        @Generated
        public B errors(String errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @Generated
        public B processingStatus(int processingStatus) {
            this.processingStatus = processingStatus;
            return (B)this.self();
        }

        @Generated
        public B lockGaps(String lockGaps) {
            this.lockGaps = lockGaps;
            return (B)this.self();
        }

        @Generated
        public B archived(Boolean archived) {
            this.archived = archived;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "TachographDataFile.TachographDataFileBuilder(super=" + super.toString() + ", driver=" + this.driver + ", device=" + this.device + ", binaryData=" + Arrays.deepToString(this.binaryData) + ", origin=" + this.origin + ", originDescription=" + this.originDescription + ", dateTime=" + this.dateTime + ", uploadDateTime=" + this.uploadDateTime + ", timestamp=" + this.timestamp + ", timestampStart=" + this.timestampStart + ", timestampEnd=" + this.timestampEnd + ", fileName=" + this.fileName + ", summary=" + this.summary + ", signature=" + this.signature + ", fileNameTgd=" + this.fileNameTgd + ", fileNameDdd=" + this.fileNameDdd + ", fileNameV1B=" + this.fileNameV1B + ", warnings=" + this.warnings + ", errors=" + this.errors + ", processingStatus=" + this.processingStatus + ", lockGaps=" + this.lockGaps + ", archived=" + this.archived + ")";
        }
    }
}

