/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.entity.zone;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.coordinate.Coordinate;
import com.geotab.model.drawing.Color;
import com.geotab.model.entity.NameEntityWithVersion;
import com.geotab.model.entity.group.Group;
import com.geotab.model.entity.zone.NoZone;
import com.geotab.model.entity.zone.type.ZoneType;
import com.geotab.model.serialization.EntityCollectionAsIdCollectionSerializer;
import com.geotab.util.Util;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;

public class Zone
extends NameEntityWithVersion {
    private String comment;
    private Boolean displayed;
    private List<ZoneType> zoneTypes;
    private List<Coordinate> points;
    private LocalDateTime activeFrom;
    private LocalDateTime activeTo;
    private Color fillColor;
    private Boolean mustIdentifyStops;
    @JsonSerialize(converter=EntityCollectionAsIdCollectionSerializer.class)
    private List<Group> groups;
    private String externalReference;

    @Override
    @JsonIgnore
    public Long getVersion() {
        return super.getVersion();
    }

    public Zone(String id) {
        this.setId(new Id(id));
        this.setName(id);
    }

    public static Zone fromSystem(String id) {
        if (Util.isEmpty(id)) {
            return null;
        }
        if ("NoZoneId".equals(id)) {
            return NoZone.getInstance();
        }
        return null;
    }

    @Generated
    protected Zone(ZoneBuilder<?, ?> b) {
        super((NameEntityWithVersion.NameEntityWithVersionBuilder<?, ?>)b);
        this.comment = ((ZoneBuilder)b).comment;
        this.displayed = ((ZoneBuilder)b).displayed;
        this.zoneTypes = ((ZoneBuilder)b).zoneTypes;
        this.points = ((ZoneBuilder)b).points;
        this.activeFrom = ((ZoneBuilder)b).activeFrom;
        this.activeTo = ((ZoneBuilder)b).activeTo;
        this.fillColor = ((ZoneBuilder)b).fillColor;
        this.mustIdentifyStops = ((ZoneBuilder)b).mustIdentifyStops;
        this.groups = ((ZoneBuilder)b).groups;
        this.externalReference = ((ZoneBuilder)b).externalReference;
    }

    @Generated
    public static ZoneBuilder<?, ?> builder() {
        return new ZoneBuilderImpl();
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public Boolean getDisplayed() {
        return this.displayed;
    }

    @Generated
    public List<ZoneType> getZoneTypes() {
        return this.zoneTypes;
    }

    @Generated
    public List<Coordinate> getPoints() {
        return this.points;
    }

    @Generated
    public LocalDateTime getActiveFrom() {
        return this.activeFrom;
    }

    @Generated
    public LocalDateTime getActiveTo() {
        return this.activeTo;
    }

    @Generated
    public Color getFillColor() {
        return this.fillColor;
    }

    @Generated
    public Boolean getMustIdentifyStops() {
        return this.mustIdentifyStops;
    }

    @Generated
    public List<Group> getGroups() {
        return this.groups;
    }

    @Generated
    public String getExternalReference() {
        return this.externalReference;
    }

    @Generated
    public Zone setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Generated
    public Zone setDisplayed(Boolean displayed) {
        this.displayed = displayed;
        return this;
    }

    @Generated
    public Zone setZoneTypes(List<ZoneType> zoneTypes) {
        this.zoneTypes = zoneTypes;
        return this;
    }

    @Generated
    public Zone setPoints(List<Coordinate> points) {
        this.points = points;
        return this;
    }

    @Generated
    public Zone setActiveFrom(LocalDateTime activeFrom) {
        this.activeFrom = activeFrom;
        return this;
    }

    @Generated
    public Zone setActiveTo(LocalDateTime activeTo) {
        this.activeTo = activeTo;
        return this;
    }

    @Generated
    public Zone setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        return this;
    }

    @Generated
    public Zone setMustIdentifyStops(Boolean mustIdentifyStops) {
        this.mustIdentifyStops = mustIdentifyStops;
        return this;
    }

    @Generated
    public Zone setGroups(List<Group> groups) {
        this.groups = groups;
        return this;
    }

    @Generated
    public Zone setExternalReference(String externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Zone)) {
            return false;
        }
        Zone other = (Zone)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$displayed = this.getDisplayed();
        Boolean other$displayed = other.getDisplayed();
        if (this$displayed == null ? other$displayed != null : !((Object)this$displayed).equals(other$displayed)) {
            return false;
        }
        Boolean this$mustIdentifyStops = this.getMustIdentifyStops();
        Boolean other$mustIdentifyStops = other.getMustIdentifyStops();
        if (this$mustIdentifyStops == null ? other$mustIdentifyStops != null : !((Object)this$mustIdentifyStops).equals(other$mustIdentifyStops)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        List<ZoneType> this$zoneTypes = this.getZoneTypes();
        List<ZoneType> other$zoneTypes = other.getZoneTypes();
        if (this$zoneTypes == null ? other$zoneTypes != null : !((Object)this$zoneTypes).equals(other$zoneTypes)) {
            return false;
        }
        List<Coordinate> this$points = this.getPoints();
        List<Coordinate> other$points = other.getPoints();
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        LocalDateTime this$activeFrom = this.getActiveFrom();
        LocalDateTime other$activeFrom = other.getActiveFrom();
        if (this$activeFrom == null ? other$activeFrom != null : !((Object)this$activeFrom).equals(other$activeFrom)) {
            return false;
        }
        LocalDateTime this$activeTo = this.getActiveTo();
        LocalDateTime other$activeTo = other.getActiveTo();
        if (this$activeTo == null ? other$activeTo != null : !((Object)this$activeTo).equals(other$activeTo)) {
            return false;
        }
        Color this$fillColor = this.getFillColor();
        Color other$fillColor = other.getFillColor();
        if (this$fillColor == null ? other$fillColor != null : !((Object)this$fillColor).equals(other$fillColor)) {
            return false;
        }
        List<Group> this$groups = this.getGroups();
        List<Group> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        String this$externalReference = this.getExternalReference();
        String other$externalReference = other.getExternalReference();
        return !(this$externalReference == null ? other$externalReference != null : !this$externalReference.equals(other$externalReference));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Zone;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $displayed = this.getDisplayed();
        result = result * 59 + ($displayed == null ? 43 : ((Object)$displayed).hashCode());
        Boolean $mustIdentifyStops = this.getMustIdentifyStops();
        result = result * 59 + ($mustIdentifyStops == null ? 43 : ((Object)$mustIdentifyStops).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        List<ZoneType> $zoneTypes = this.getZoneTypes();
        result = result * 59 + ($zoneTypes == null ? 43 : ((Object)$zoneTypes).hashCode());
        List<Coordinate> $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        LocalDateTime $activeFrom = this.getActiveFrom();
        result = result * 59 + ($activeFrom == null ? 43 : ((Object)$activeFrom).hashCode());
        LocalDateTime $activeTo = this.getActiveTo();
        result = result * 59 + ($activeTo == null ? 43 : ((Object)$activeTo).hashCode());
        Color $fillColor = this.getFillColor();
        result = result * 59 + ($fillColor == null ? 43 : ((Object)$fillColor).hashCode());
        List<Group> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        String $externalReference = this.getExternalReference();
        result = result * 59 + ($externalReference == null ? 43 : $externalReference.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Zone(super=" + super.toString() + ", comment=" + this.getComment() + ", displayed=" + this.getDisplayed() + ", zoneTypes=" + this.getZoneTypes() + ", points=" + this.getPoints() + ", activeFrom=" + this.getActiveFrom() + ", activeTo=" + this.getActiveTo() + ", fillColor=" + this.getFillColor() + ", mustIdentifyStops=" + this.getMustIdentifyStops() + ", groups=" + this.getGroups() + ", externalReference=" + this.getExternalReference() + ")";
    }

    @Generated
    public Zone() {
    }

    @Generated
    private static final class ZoneBuilderImpl
    extends ZoneBuilder<Zone, ZoneBuilderImpl> {
        @Generated
        private ZoneBuilderImpl() {
        }

        @Override
        @Generated
        protected ZoneBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Zone build() {
            return new Zone(this);
        }
    }

    @Generated
    public static abstract class ZoneBuilder<C extends Zone, B extends ZoneBuilder<C, B>>
    extends NameEntityWithVersion.NameEntityWithVersionBuilder<C, B> {
        @Generated
        private String comment;
        @Generated
        private Boolean displayed;
        @Generated
        private List<ZoneType> zoneTypes;
        @Generated
        private List<Coordinate> points;
        @Generated
        private LocalDateTime activeFrom;
        @Generated
        private LocalDateTime activeTo;
        @Generated
        private Color fillColor;
        @Generated
        private Boolean mustIdentifyStops;
        @Generated
        private List<Group> groups;
        @Generated
        private String externalReference;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        @Generated
        public B displayed(Boolean displayed) {
            this.displayed = displayed;
            return (B)this.self();
        }

        @Generated
        public B zoneTypes(List<ZoneType> zoneTypes) {
            this.zoneTypes = zoneTypes;
            return (B)this.self();
        }

        @Generated
        public B points(List<Coordinate> points) {
            this.points = points;
            return (B)this.self();
        }

        @Generated
        public B activeFrom(LocalDateTime activeFrom) {
            this.activeFrom = activeFrom;
            return (B)this.self();
        }

        @Generated
        public B activeTo(LocalDateTime activeTo) {
            this.activeTo = activeTo;
            return (B)this.self();
        }

        @Generated
        public B fillColor(Color fillColor) {
            this.fillColor = fillColor;
            return (B)this.self();
        }

        @Generated
        public B mustIdentifyStops(Boolean mustIdentifyStops) {
            this.mustIdentifyStops = mustIdentifyStops;
            return (B)this.self();
        }

        @Generated
        public B groups(List<Group> groups) {
            this.groups = groups;
            return (B)this.self();
        }

        @Generated
        public B externalReference(String externalReference) {
            this.externalReference = externalReference;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Zone.ZoneBuilder(super=" + super.toString() + ", comment=" + this.comment + ", displayed=" + this.displayed + ", zoneTypes=" + this.zoneTypes + ", points=" + this.points + ", activeFrom=" + this.activeFrom + ", activeTo=" + this.activeTo + ", fillColor=" + this.fillColor + ", mustIdentifyStops=" + this.mustIdentifyStops + ", groups=" + this.groups + ", externalReference=" + this.externalReference + ")";
        }
    }
}

