/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.error;

import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum JsonRpcErrorCode implements HasName
{
    UNKNOWN("Unknown", -1),
    PARSE_ERROR("ParseError", -32700),
    INTERNAL_ERROR("InternalError", -32603),
    INVALID_PARAMS("InvalidParams", -32602),
    METHOD_NOT_FOUND("MethodNotFound", -32601),
    INVALID_REQUEST("InvalidRequest", -32600),
    GROUP_RELATION_VIOLATED_ERROR("GroupRelationViolatedError", -32599),
    DB_UNAVAILABLE_GENERAL_ERROR("DbUnavailableGeneralError", -32590),
    DB_UNAVAILABLE_CONNECTION_FAILURE("DbUnavailableConnectionFailure", -32589),
    DB_UNAVAILABLE_UNKNOWN_DATABASE("DbUnavailableUnknownDatabase", -32588),
    DB_UNAVAILABLE_INITIALIZING("DbUnavailableInitializing", -32587),
    DB_UNAVAILABLE_OPERATION_ABORTED("DbUnavailableOperationAborted", -32586),
    INVALID_CERTIFICATE_EXCEPTION("InvalidCertificateException", -32001),
    INTERNAL_SERVER_ERROR("InternalServerError", -32000),
    NONE("None", 0);

    private final String name;
    private final int code;

    private JsonRpcErrorCode(String name, int code) {
        this.name = name;
        this.code = code;
    }

    @Override
    @JsonValue
    public String getName() {
        return this.name;
    }

    public int getCode() {
        return this.code;
    }

    public static JsonRpcErrorCode getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (JsonRpcErrorCode value : JsonRpcErrorCode.values()) {
            if (value.getCode() != code.intValue()) continue;
            return value;
        }
        return null;
    }
}

