/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.diagnostic.BasicDiagnostic;
import com.geotab.model.entity.diagnostic.BrpFaultDiagnostic;
import com.geotab.model.entity.diagnostic.DataDiagnostic;
import com.geotab.model.entity.diagnostic.Diagnostic;
import com.geotab.model.entity.diagnostic.DiagnosticType;
import com.geotab.model.entity.diagnostic.GmcccFaultDiagnostic;
import com.geotab.model.entity.diagnostic.GoDiagnostic;
import com.geotab.model.entity.diagnostic.GoFaultDiagnostic;
import com.geotab.model.entity.diagnostic.LegacyFaultDiagnostic;
import com.geotab.model.entity.diagnostic.NoDiagnostic;
import com.geotab.model.entity.diagnostic.ObdFaultDiagnostic;
import com.geotab.model.entity.diagnostic.ObdSaFaultDiagnostic;
import com.geotab.model.entity.diagnostic.Pid;
import com.geotab.model.entity.diagnostic.ProprietaryFaultDiagnostic;
import com.geotab.model.entity.diagnostic.Sid;
import com.geotab.model.entity.diagnostic.SuspectParameter;
import com.geotab.model.serialization.ApiCustomDeserializerModifier;
import java.io.IOException;

public class DiagnosticDeserializer
extends JsonDeserializer<Diagnostic> {
    public Diagnostic deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        String id;
        ObjectCodec parserCodec = jsonParser.getCodec();
        JsonNode node = (JsonNode)parserCodec.readTree(jsonParser);
        if (node.isTextual() && "NoDiagnosticId".equals(node.textValue())) {
            return NoDiagnostic.getInstance();
        }
        String string = id = node.get("id") != null ? node.get("id").textValue() : null;
        if ("NoDiagnosticId".equals(id)) {
            return NoDiagnostic.getInstance();
        }
        DiagnosticType diagnosticType = node.get("diagnosticType") == null ? DiagnosticType.NONE : (DiagnosticType)parserCodec.treeToValue((TreeNode)node.get("diagnosticType"), DiagnosticType.class);
        switch (diagnosticType) {
            case DATA_DIAGNOSTIC: {
                return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, DataDiagnostic.class);
            }
            case GO_DIAGNOSTIC: {
                return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, GoDiagnostic.class);
            }
            case PID: {
                return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, Pid.class);
            }
            case SID: {
                return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, Sid.class);
            }
            case SUSPECT_PARAMETER: {
                return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, SuspectParameter.class);
            }
            case OBD_FAULT: {
                return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, ObdFaultDiagnostic.class);
            }
            case GO_FAULT: {
                return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, GoFaultDiagnostic.class);
            }
            case OBD_WWH_FAULT: {
                return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, ObdSaFaultDiagnostic.class);
            }
            case PROPRIETARY_FAULT: {
                return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, ProprietaryFaultDiagnostic.class);
            }
            case LEGACY_FAULT: {
                return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, LegacyFaultDiagnostic.class);
            }
            case GMCCC_FAULT: {
                return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, GmcccFaultDiagnostic.class);
            }
            case BRP_FAULT: {
                return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, BrpFaultDiagnostic.class);
            }
        }
        return ApiCustomDeserializerModifier.defaultDeserialize(parserCodec, context, node, BasicDiagnostic.class);
    }
}

