/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class LongSerializer
extends JsonSerializer<Long> {
    public void serialize(Long value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
        jsonGenerator.writeString(LongSerializer.longToString(value));
    }

    private static String longToString(long version) {
        char[] chars = new char[16];
        int p = 0;
        for (int i = 7; i >= 0; --i) {
            int b = (int)(version >> 8 * i);
            chars[p++] = LongSerializer.hexToChar(b >> 4);
            chars[p++] = LongSerializer.hexToChar(b);
        }
        return new String(chars);
    }

    private static char hexToChar(int a) {
        return (char)((a &= 0xF) > 9 ? a - 10 + 97 : a + 48);
    }
}

