/*
 * Decompiled with CFR 0.152.
 */
package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertificateDeserializer
extends JsonDeserializer<X509Certificate> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(X509CertificateDeserializer.class);

    public X509Certificate deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        ObjectCodec parserCodec = jsonParser.getCodec();
        JsonNode node = (JsonNode)parserCodec.readTree(jsonParser);
        if (node.isTextual()) {
            try {
                return X509CertificateDeserializer.buildX509Certificate(node.textValue());
            }
            catch (CertificateException e) {
                log.error("Can not create X509Certificate", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static X509Certificate buildX509Certificate(String certificateString) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(X509CertificateDeserializer.certificateBytesFromString(certificateString)));
    }

    public static byte[] certificateBytesFromString(String certificateString) {
        if (Util.isEmpty(certificateString)) {
            return new byte[0];
        }
        byte[] certificateBytes = new byte[certificateString.length() / 2];
        for (int i = 0; i < certificateBytes.length; ++i) {
            certificateBytes[i] = (byte)Integer.parseInt(certificateString.substring(i * 2, i * 2 + 2), 16);
        }
        return certificateBytes;
    }
}

