/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.android.autoprovider;

import android.content.ContentResolver;
import android.database.Cursor;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import com.getbase.android.autoprovider.AutoUris;
import com.getbase.android.autoprovider.ClassToTable;
import com.getbase.android.autoprovider.MultiUriCursorWrapper;
import com.getbase.android.autoprovider.SqliteQueryTablesFinder;
import com.getbase.android.autoprovider.SqliteSchemaHelper;
import com.getbase.android.autoprovider.SqliteViewDependenciesResolver;
import com.getbase.android.db.fluentsqlite.Query;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.chalup.thneed.models.DatabaseModel;
import org.chalup.thneed.models.PojoModel;

public class AutoNotificationUriSetter<TModel extends DatabaseModel & PojoModel> {
    private final SqliteViewDependenciesResolver mViewDependenciesResolver;
    private final SqliteQueryTablesFinder mTablesFinder;
    private final ContentResolver mContentResolver;
    private final AutoUris<TModel> mAutoUris;
    private final ClassToTable<TModel> mClassToTable;
    private final Function<String, Iterable<String>> mResolveViewsDependencies = new Function<String, Iterable<String>>(){

        public Iterable<String> apply(String tableOrView) {
            return AutoNotificationUriSetter.this.mViewDependenciesResolver.getTables(tableOrView);
        }
    };
    private final Function<String, Uri> mGetUriForTable = new Function<String, Uri>(){

        public Uri apply(String table) {
            return AutoNotificationUriSetter.this.mAutoUris.model(AutoNotificationUriSetter.this.mClassToTable.getClassForTable(table)).toUri();
        }
    };
    private final Predicate<String> mFilterNonModelTables = new Predicate<String>(){

        public boolean apply(String table) {
            return AutoNotificationUriSetter.this.mClassToTable.hasTable(table);
        }
    };

    public AutoNotificationUriSetter(SQLiteOpenHelper database, ContentResolver contentResolver, AutoUris<TModel> autoUris, ClassToTable<TModel> classToTable) {
        SqliteSchemaHelper schemaHelper = new SqliteSchemaHelper(database);
        this.mViewDependenciesResolver = new SqliteViewDependenciesResolver(schemaHelper);
        this.mTablesFinder = new SqliteQueryTablesFinder(schemaHelper);
        this.mContentResolver = contentResolver;
        this.mClassToTable = classToTable;
        this.mAutoUris = autoUris;
    }

    public MultiUriCursorWrapper setNotificationUris(Cursor cursor, Query query) {
        return new MultiUriCursorWrapper(cursor).withNotificationUris(this.mContentResolver, (Iterable<Uri>)this.getUris(query));
    }

    public MultiUriCursorWrapper setNotificationUris(Cursor cursor, Query.QueryBuilder query) {
        return new MultiUriCursorWrapper(cursor).withNotificationUris(this.mContentResolver, (Iterable<Uri>)this.getUris(query));
    }

    public MultiUriCursorWrapper setNotificationUris(Cursor cursor, String rawQuery) {
        return new MultiUriCursorWrapper(cursor).withNotificationUris(this.mContentResolver, (Iterable<Uri>)this.getUris(rawQuery));
    }

    public ImmutableSet<Uri> getUris(String rawQuery) {
        return this.getUris((Set<String>)this.mTablesFinder.getTablesFromRawSql(rawQuery));
    }

    private ImmutableSet<Uri> getUris(Query query) {
        return this.getUris(query.getTables());
    }

    public ImmutableSet<Uri> getUris(Query.QueryBuilder queryBuilder) {
        return this.getUris(queryBuilder.getTables());
    }

    private ImmutableSet<Uri> getUris(Set<String> tables) {
        return FluentIterable.from(tables).transformAndConcat(this.mResolveViewsDependencies).filter(this.mFilterNonModelTables).transform(this.mGetUriForTable).toSet();
    }
}

