/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.android.autoprovider;

import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.getbase.android.autoprovider.ContentUriHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class DelegatingContentUriHandler
implements ContentUriHandler {
    private static final String TAG = DelegatingContentUriHandler.class.getSimpleName();
    private final LinkedList<ContentUriHandler> mHandlers = Lists.newLinkedList();

    private ContentUriHandler getHandler(Uri uri, ContentUriHandler.ContentUriAction action) {
        return this.getContentUriHandler(this.mHandlers.iterator(), uri, action);
    }

    private ContentUriHandler getContentUriHandler(Iterator<ContentUriHandler> iterator, Uri uri, ContentUriHandler.ContentUriAction action) {
        Preconditions.checkState((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            ContentUriHandler handler = iterator.next();
            if (!handler.canHandle(uri, action)) continue;
            Log.d((String)TAG, (String)(handler.getClass().getSimpleName() + " will handle " + (Object)((Object)action) + " on " + Uri.decode((String)uri.toString())));
            return handler;
        }
        return null;
    }

    public void addHandlers(ContentUriHandler ... handlers) {
        Collections.addAll(this.mHandlers, handlers);
    }

    public ContentUriHandler getDelegateHandler(Uri uri, ContentUriHandler.ContentUriAction action, ContentUriHandler skipPast) {
        return this.getContentUriHandler(DelegatingContentUriHandler.advancePast(this.mHandlers.iterator(), skipPast), uri, action);
    }

    private static <T> Iterator<T> advancePast(Iterator<T> iterator, T element) {
        while (iterator.hasNext() && iterator.next() != element) {
        }
        return iterator;
    }

    @Override
    public boolean canHandle(Uri uri, ContentUriHandler.ContentUriAction action) {
        return this.getHandler(uri, action) != null;
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return this.getHandler(uri, ContentUriHandler.ContentUriAction.QUERY).query(uri, projection, selection, selectionArgs, sortOrder);
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return this.getHandler(uri, ContentUriHandler.ContentUriAction.UPDATE).update(uri, values, selection, selectionArgs);
    }

    @Override
    public Uri insert(Uri uri, ContentValues values) {
        return this.getHandler(uri, ContentUriHandler.ContentUriAction.INSERT).insert(uri, values);
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return this.getHandler(uri, ContentUriHandler.ContentUriAction.DELETE).delete(uri, selection, selectionArgs);
    }

    @Override
    public String getType(Uri uri) {
        return this.getHandler(uri, ContentUriHandler.ContentUriAction.GET_TYPE).getType(uri);
    }
}

