/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.android.autoprovider;

import android.net.Uri;
import com.getbase.android.autoprovider.AutoUris;
import com.getbase.android.autoprovider.EntityUri;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import org.json.JSONException;
import org.json.JSONObject;

public class EntityRelation {
    public final Optional<String> relationColumn;
    public final EntityUri entityUri;

    public EntityRelation(EntityUri entityUri) {
        this.entityUri = entityUri;
        this.relationColumn = Optional.absent();
    }

    public EntityRelation(String relationColumn, EntityUri entityUri) {
        this.entityUri = entityUri;
        this.relationColumn = Optional.of((Object)relationColumn);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.relationColumn, this.entityUri});
    }

    public boolean equals(Object o) {
        if (o instanceof EntityRelation) {
            EntityRelation otherRelation = (EntityRelation)o;
            return Objects.equal(this.relationColumn, otherRelation.relationColumn) && Objects.equal((Object)this.entityUri, (Object)otherRelation.entityUri);
        }
        return false;
    }

    public String toString() {
        return this.entityUri.getModel().getSimpleName() + ": " + this.entityUri;
    }

    public String toParameterString() {
        if (this.relationColumn.isPresent()) {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("uri", (Object)this.entityUri.toUri().toString());
                jsonObject.put("by", this.relationColumn.get());
                return jsonObject.toString();
            }
            catch (JSONException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.entityUri.toUri().toString();
    }

    public static EntityRelation fromParameter(AutoUris autoUris, String param) {
        try {
            JSONObject object = new JSONObject(param);
            return new EntityRelation(object.getString("by"), autoUris.getEntityUri(Uri.parse((String)object.getString("uri"))));
        }
        catch (JSONException e) {
            return new EntityRelation(autoUris.getEntityUri(Uri.parse((String)param)));
        }
    }
}

