/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.android.autoprovider;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.getbase.android.sqlitemaster.SQLiteMaster;
import com.getbase.android.sqlitemaster.SQLiteSchemaPart;
import com.getbase.android.sqlitemaster.SQLiteSchemaPartType;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;

public class SqliteSchemaHelper {
    private final SQLiteOpenHelper mDatabase;
    private final Supplier<ImmutableSet<String>> mTables = Suppliers.memoize((Supplier)new Supplier<ImmutableSet<String>>(){

        public ImmutableSet<String> get() {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (SQLiteSchemaPart part : SQLiteMaster.getSQLiteSchemaParts((SQLiteDatabase)SqliteSchemaHelper.this.mDatabase.getReadableDatabase(), (SQLiteSchemaPartType)SQLiteSchemaPartType.TABLE)) {
                builder.add((Object)part.name.toLowerCase(Locale.US));
            }
            return builder.build();
        }
    });
    private final Supplier<ImmutableMap<String, String>> mViewsWithSqlStatements = Suppliers.memoize((Supplier)new Supplier<ImmutableMap<String, String>>(){

        public ImmutableMap<String, String> get() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (SQLiteSchemaPart part : SQLiteMaster.getSQLiteSchemaParts((SQLiteDatabase)SqliteSchemaHelper.this.mDatabase.getReadableDatabase(), (SQLiteSchemaPartType)SQLiteSchemaPartType.VIEW)) {
                builder.put((Object)part.name.toLowerCase(Locale.US), (Object)part.sql.toLowerCase(Locale.US));
            }
            return builder.build();
        }
    });

    public SqliteSchemaHelper(SQLiteOpenHelper database) {
        this.mDatabase = database;
    }

    public ImmutableSet<String> getTables() {
        return (ImmutableSet)this.mTables.get();
    }

    public ImmutableSet<String> getViews() {
        return ((ImmutableMap)this.mViewsWithSqlStatements.get()).keySet();
    }

    public String getViewCreateStatement(String view) {
        return (String)((ImmutableMap)this.mViewsWithSqlStatements.get()).get((Object)view);
    }
}

