/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.android.autoprovider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.text.TextUtils;
import com.getbase.android.autoprovider.AutoNotificationUriSetter;
import com.getbase.android.autoprovider.AutoUri;
import com.getbase.android.autoprovider.AutoUriVisitor;
import com.getbase.android.autoprovider.AutoUris;
import com.getbase.android.autoprovider.BaseContentUriHandler;
import com.getbase.android.autoprovider.ContentTypeProvider;
import com.getbase.android.autoprovider.ContentTypeVisitor;
import com.getbase.android.autoprovider.ContentUriHandler;
import com.getbase.android.autoprovider.CrudOperationsResolver;
import com.getbase.android.autoprovider.CustomUri;
import com.getbase.android.autoprovider.EntityUri;
import com.getbase.android.autoprovider.ModelUri;
import com.getbase.android.db.fluentsqlite.Delete;
import com.getbase.android.db.fluentsqlite.Query;
import com.getbase.android.db.fluentsqlite.Update;
import java.util.EnumSet;
import org.chalup.thneed.ModelGraph;
import org.chalup.thneed.models.DatabaseModel;
import org.chalup.thneed.models.PojoModel;

public class AutoUriHandler<TModel extends DatabaseModel & PojoModel>
extends BaseContentUriHandler {
    private final AutoUris<TModel> mAutoUris;
    private final ContentTypeVisitor mContentTypeVisitor;
    private final CrudOperationsResolver mCrudOperationsResolver;
    private final AutoUriVisitor<EnumSet<ContentUriHandler.ContentUriAction>> mSupportedActionsVisitor;
    private final AutoNotificationUriSetter mAutoNotificationUriSetter;

    public AutoUriHandler(SQLiteOpenHelper database, ContentResolver contentResolver, AutoUris<TModel> autoUris, ContentTypeProvider<TModel> contentTypeProvider, ModelGraph<TModel> modelGraph, AutoNotificationUriSetter<TModel> autoNotificationUriSetter) {
        super(database, contentResolver);
        this.mAutoUris = autoUris;
        this.mAutoNotificationUriSetter = autoNotificationUriSetter;
        this.mContentTypeVisitor = new ContentTypeVisitor(contentTypeProvider);
        this.mCrudOperationsResolver = new CrudOperationsResolver(database, modelGraph);
        this.mSupportedActionsVisitor = new AutoUriVisitor<EnumSet<ContentUriHandler.ContentUriAction>>(){

            @Override
            public EnumSet<ContentUriHandler.ContentUriAction> visit(EntityUri uri) {
                return EnumSet.complementOf(EnumSet.of(ContentUriHandler.ContentUriAction.INSERT));
            }

            @Override
            public EnumSet<ContentUriHandler.ContentUriAction> visit(ModelUri uri) {
                return EnumSet.allOf(ContentUriHandler.ContentUriAction.class);
            }

            @Override
            public EnumSet<ContentUriHandler.ContentUriAction> visit(CustomUri uri) {
                return EnumSet.noneOf(ContentUriHandler.ContentUriAction.class);
            }
        };
    }

    @Override
    public String getType(Uri uri) {
        return this.mAutoUris.getAutoUri(uri).accept(this.mContentTypeVisitor);
    }

    @Override
    public boolean canHandle(Uri uri, ContentUriHandler.ContentUriAction action) {
        return this.mAutoUris.getAutoUri(uri).accept(this.mSupportedActionsVisitor).contains((Object)action);
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Query.ColumnListTableSelector queryBuilder = this.mAutoUris.getAutoUri(uri).accept(this.mCrudOperationsResolver.getQueryBuilderVisitor()).columns(projection);
        if (!TextUtils.isEmpty((CharSequence)selection)) {
            queryBuilder.where(selection, (Object[])selectionArgs);
        }
        if (!TextUtils.isEmpty((CharSequence)sortOrder)) {
            queryBuilder.orderBy(sortOrder);
        }
        return this.mAutoNotificationUriSetter.setNotificationUris((Cursor)queryBuilder.perform(this.getReadableDb()), (Query.QueryBuilder)queryBuilder);
    }

    @Override
    public Uri insert(Uri uri, ContentValues values) {
        AutoUri autoUri = this.mAutoUris.getAutoUri(uri);
        long id = autoUri.accept(this.mCrudOperationsResolver.getInsertVisitor()).values(values).performOrThrow(this.getWritableDb());
        this.notifyChange(autoUri);
        return this.mAutoUris.model(autoUri.getModel()).id(id).toUri();
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int count;
        AutoUri autoUri = this.mAutoUris.getAutoUri(uri);
        Delete delete = autoUri.accept(this.mCrudOperationsResolver.getDeleteVisitor());
        if (!TextUtils.isEmpty((CharSequence)selection)) {
            delete = delete.where(selection, (Object[])selectionArgs);
        }
        if ((count = delete.perform(this.getWritableDb())) > 0) {
            this.notifyChange(autoUri);
        }
        return count;
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int count;
        AutoUri autoUri = this.mAutoUris.getAutoUri(uri);
        Update update = autoUri.accept(this.mCrudOperationsResolver.getUpdateVisitor()).values(values);
        if (!TextUtils.isEmpty((CharSequence)selection)) {
            update = update.where(selection, (Object[])selectionArgs);
        }
        if ((count = update.perform(this.getWritableDb())) > 0) {
            this.notifyChange(autoUri);
        }
        return count;
    }

    private void notifyChange(AutoUri autoUri) {
        this.getContentResolver().notifyChange(this.mAutoUris.model(autoUri.getModel()).toUri(), null, false);
    }
}

