/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.android.autoprovider;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.util.LruCache;
import com.getbase.android.autoprovider.AutoUri;
import com.getbase.android.autoprovider.AutoUriRelationBuilder;
import com.getbase.android.autoprovider.AutoUriVisitor;
import com.getbase.android.autoprovider.ClassToTable;
import com.getbase.android.autoprovider.CustomUri;
import com.getbase.android.autoprovider.CustomUriBuilder;
import com.getbase.android.autoprovider.EntityRelation;
import com.getbase.android.autoprovider.EntityUri;
import com.getbase.android.autoprovider.ModelUri;
import com.getbase.android.autoprovider.ModelUriBuilder;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.chalup.thneed.ManyToManyRelationship;
import org.chalup.thneed.ModelGraph;
import org.chalup.thneed.OneToManyRelationship;
import org.chalup.thneed.OneToOneRelationship;
import org.chalup.thneed.PolymorphicRelationship;
import org.chalup.thneed.RecursiveModelRelationship;
import org.chalup.thneed.RelationshipVisitor;
import org.chalup.thneed.models.DatabaseModel;
import org.chalup.thneed.models.PojoModel;

public class AutoUris<TModel extends DatabaseModel & PojoModel>
implements ModelUriBuilder,
CustomUriBuilder {
    private static final String RELATED_TO_QUERY_PARAM = "relatedTo";
    private static final String ID_COLUMN_QUERY_PARAM = "idColumn";
    private final String mAuthority;
    private final String mIdColumnName;
    private final ClassToTable<TModel> mClassToTableMap;
    private final Table<Class<?>, Class<?>, Set<String>> mRelationsByClasses;
    private LruCache<Uri, AutoUri> mParsingCache = new LruCache<Uri, AutoUri>(20){

        protected AutoUri create(Uri uri) {
            return AutoUris.this.mRootAutoUriParser.parse(uri);
        }
    };
    private final AutoUriParser<CustomUri> mRootAutoUriParser = new AutoUriParser<CustomUri>((CustomUri)new CustomUriImpl()){

        @Override
        protected AutoUriParser parseSegment(Uri uri, String pathSegment, boolean isLastSegment) {
            if (this.isModel(pathSegment)) {
                return new ModelUriParser(AutoUris.this.model(this.getModel(pathSegment)));
            }
            return new CustomUriParser(AutoUris.this.path(pathSegment));
        }
    };

    AutoUris(ModelGraph<TModel> modelGraph, ClassToTable<TModel> classToTable, String authority, String idColumnName) {
        this.mAuthority = authority;
        this.mIdColumnName = idColumnName;
        this.mClassToTableMap = classToTable;
        HashBasedTable relationsByClass = HashBasedTable.create();
        modelGraph.accept(new RelationshipVisitor<TModel>((Table)relationsByClass){
            final /* synthetic */ Table val$relationsByClass;
            {
                this.val$relationsByClass = table;
            }

            private void addRelation(Class<?> modelClass, Class<?> referencedModelClass, String columnName) {
                Set relationColumns = (Set)this.val$relationsByClass.get(modelClass, referencedModelClass);
                if (relationColumns == null) {
                    relationColumns = Sets.newHashSet();
                    this.val$relationsByClass.put(modelClass, referencedModelClass, (Object)relationColumns);
                }
                relationColumns.add(columnName);
            }

            public void visit(OneToManyRelationship<? extends TModel> relationship) {
                DatabaseModel manyModel = (DatabaseModel)relationship.mModel;
                DatabaseModel oneModel = (DatabaseModel)relationship.mReferencedModel;
                this.addRelation(((PojoModel)manyModel).getModelClass(), ((PojoModel)oneModel).getModelClass(), relationship.mLinkedByColumn);
            }

            public void visit(OneToOneRelationship<? extends TModel> relationship) {
                DatabaseModel model = (DatabaseModel)relationship.mModel;
                DatabaseModel linkedModel = (DatabaseModel)relationship.mLinkedModel;
                this.addRelation(((PojoModel)linkedModel).getModelClass(), ((PojoModel)model).getModelClass(), relationship.mLinkedByColumn);
            }

            public void visit(RecursiveModelRelationship<? extends TModel> relationship) {
                DatabaseModel model = (DatabaseModel)relationship.mModel;
                this.addRelation(((PojoModel)model).getModelClass(), ((PojoModel)model).getModelClass(), relationship.mGroupByColumn);
            }

            public void visit(ManyToManyRelationship<? extends TModel> relationship) {
            }

            public void visit(PolymorphicRelationship<? extends TModel> relationship) {
                DatabaseModel model = (DatabaseModel)relationship.mModel;
                for (DatabaseModel polyModel : relationship.mPolymorphicModels.values()) {
                    this.addRelation(((PojoModel)model).getModelClass(), ((PojoModel)polyModel).getModelClass(), relationship.mPolymorphicModelIdColumn);
                }
            }
        });
        this.mRelationsByClasses = ImmutableTable.copyOf((Table)relationsByClass);
    }

    public static <T extends DatabaseModel & PojoModel> AuthoritySelector<T> from(ModelGraph<T> modelGraph) {
        return new Builder<T>(modelGraph, new ClassToTable<T>(modelGraph));
    }

    public static <T extends DatabaseModel & PojoModel> AuthoritySelector<T> from(ModelGraph<T> modelGraph, ClassToTable<T> classToTable) {
        return new Builder<T>(modelGraph, classToTable);
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    @Override
    public ModelUri model(Class<?> klass) {
        Preconditions.checkNotNull(klass);
        Preconditions.checkArgument((boolean)this.mClassToTableMap.hasClass(klass), (String)"Model %s is not present in supplied model graph", (Object[])new Object[]{klass.getSimpleName()});
        return new ModelUriImpl(klass);
    }

    @Override
    public CustomUri path(Object path) {
        return new CustomUriImpl().path(path);
    }

    @Override
    public CustomUri path(Class<?> model) {
        return new CustomUriImpl().path(model);
    }

    public ModelUri getModelUri(Uri uri) {
        AutoUri autoUri = this.getAutoUri(uri);
        Preconditions.checkArgument((boolean)(autoUri instanceof ModelUri), (String)"%s is not a ModelUri: %s", (Object[])new Object[]{uri, autoUri});
        return (ModelUri)autoUri;
    }

    public EntityUri getEntityUri(Uri uri) {
        AutoUri autoUri = this.getAutoUri(uri);
        Preconditions.checkArgument((boolean)(autoUri instanceof EntityUri), (String)"%s is not an EntityUri: %s", (Object[])new Object[]{uri, autoUri});
        return (EntityUri)autoUri;
    }

    public AutoUri getAutoUri(Uri uri) {
        Preconditions.checkNotNull((Object)uri);
        Preconditions.checkArgument((boolean)uri.getScheme().equals("content"), (String)"invalid uri scheme: %s, (expected: %s), uri: %s", (Object[])new Object[]{uri.getScheme(), "content", uri});
        Preconditions.checkArgument((boolean)uri.getAuthority().equals(this.mAuthority), (String)"invalid uri authority: %s (expected: %s), uri: %s", (Object[])new Object[]{uri.getAuthority(), this.mAuthority, uri});
        return (AutoUri)this.mParsingCache.get((Object)uri);
    }

    public long getEntityId(Uri uri, Class<?> model) {
        return this.getEntityId(this.getAutoUri(uri), model);
    }

    public long getEntityId(final @NonNull AutoUri autoUri, final Class<?> model) {
        EntityUri entityUri = autoUri.accept(new AutoUriVisitor<EntityUri>(){
            private EntityUri mResult;

            @Override
            public EntityUri visit(EntityUri uri) {
                if (uri.getModel().equals(model)) {
                    Preconditions.checkArgument((this.mResult == null ? 1 : 0) != 0, (String)"Duplicate %s.class relation in %s (%s)", (Object[])new Object[]{model.getSimpleName(), autoUri.toUri(), autoUri});
                    this.mResult = uri;
                }
                this.processRelatedEntities(uri);
                return this.mResult;
            }

            @Override
            public EntityUri visit(ModelUri uri) {
                this.processRelatedEntities(uri);
                return this.mResult;
            }

            @Override
            public EntityUri visit(CustomUri uri) {
                this.processRelatedEntities(uri);
                return this.mResult;
            }

            private void processRelatedEntities(AutoUri autoUri2) {
                for (EntityRelation entityRelation : autoUri2.getRelatedEntities()) {
                    entityRelation.entityUri.accept(this);
                }
            }
        });
        Preconditions.checkArgument((entityUri != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)entityUri.getIdColumn().equals(this.mIdColumnName));
        return entityUri.getId();
    }

    private static boolean isDigitsWithSignOnly(String str) {
        return str.matches("-?\\d+?");
    }

    private class CustomUriParser
    extends AutoUriParser<CustomUri> {
        private CustomUriParser(CustomUri uri) {
            super(AutoUris.this, (AutoUriRelationBuilder)uri);
        }

        @Override
        protected AutoUriParser parseSegment(Uri uri, String pathSegment, boolean isLastSegment) {
            if (this.isModel(pathSegment)) {
                return new CustomUriParser(((CustomUri)this.mUri).model(this.getModel(pathSegment)));
            }
            return new CustomUriParser(((CustomUri)this.mUri).path(pathSegment));
        }
    }

    private class EntityUriParser
    extends AutoUriParser<EntityUri> {
        public EntityUriParser(EntityUri uri) {
            super(AutoUris.this, (AutoUriRelationBuilder)uri);
        }

        @Override
        protected AutoUriParser parseSegment(Uri uri, String pathSegment, boolean isLastSegment) {
            if (this.isModel(pathSegment)) {
                Class<?> relationModel = ((EntityUri)this.mUri).getModelUri().getModel();
                Class<?> model = this.getModel(pathSegment);
                Set relationColumns = (Set)AutoUris.this.mRelationsByClasses.get(model, relationModel);
                if (relationColumns == null || relationColumns.size() != 1) {
                    return new CustomUriParser(((EntityUri)this.mUri).path(model));
                }
                return new ModelUriParser(((EntityUri)this.mUri).model(model));
            }
            return new CustomUriParser(((EntityUri)this.mUri).path(pathSegment));
        }
    }

    private class ModelUriParser
    extends AutoUriParser<ModelUri> {
        private ModelUriParser(ModelUri uri) {
            super(AutoUris.this, (AutoUriRelationBuilder)uri);
        }

        @Override
        protected AutoUriParser parseSegment(Uri uri, String pathSegment, boolean isLastSegment) {
            if (this.isModel(pathSegment)) {
                return new CustomUriParser(((ModelUri)this.mUri).path(this.getModel(pathSegment)));
            }
            if (AutoUris.isDigitsWithSignOnly(pathSegment)) {
                String idColumn = isLastSegment && uri.getQueryParameter(AutoUris.ID_COLUMN_QUERY_PARAM) != null ? uri.getQueryParameter(AutoUris.ID_COLUMN_QUERY_PARAM) : AutoUris.this.mIdColumnName;
                return new EntityUriParser(((ModelUri)this.mUri).id(idColumn, Long.parseLong(pathSegment)));
            }
            return new CustomUriParser(((ModelUri)this.mUri).path(pathSegment));
        }
    }

    private static abstract class AutoUriParser<T extends AutoUriRelationBuilder<T> & AutoUri> {
        protected final T mUri;
        final /* synthetic */ AutoUris this$0;

        protected AutoUriParser(T result) {
            this.this$0 = var1_1;
            this.mUri = result;
        }

        public final AutoUri parse(Uri uri) {
            AutoUriParser parser = this;
            Iterator iterator = uri.getPathSegments().iterator();
            while (iterator.hasNext()) {
                String pathSegment = (String)iterator.next();
                parser = parser.parseSegment(uri, pathSegment, !iterator.hasNext());
            }
            return this.getAutoUriWithRelatedEntities(parser, uri);
        }

        private <TResult extends AutoUriRelationBuilder<TResult> & AutoUri> AutoUri getAutoUriWithRelatedEntities(AutoUriParser<TResult> parser, Uri uri) {
            Object autoUri = parser.mUri;
            for (String relationQueryParam : uri.getQueryParameters(AutoUris.RELATED_TO_QUERY_PARAM)) {
                EntityRelation relatedEntity = EntityRelation.fromParameter(this.this$0, relationQueryParam);
                if (relatedEntity.relationColumn.isPresent()) {
                    autoUri = (AutoUriRelationBuilder)autoUri.relatedTo((String)relatedEntity.relationColumn.get(), relatedEntity.entityUri);
                    continue;
                }
                autoUri = (AutoUriRelationBuilder)autoUri.relatedTo(relatedEntity.entityUri);
            }
            return (AutoUri)autoUri;
        }

        protected boolean isModel(String pathSegment) {
            return this.this$0.mClassToTableMap.hasTable(pathSegment);
        }

        protected Class<?> getModel(String pathSegment) {
            return this.this$0.mClassToTableMap.getClassForTable(pathSegment);
        }

        protected abstract AutoUriParser parseSegment(Uri var1, String var2, boolean var3);
    }

    private class EntityUriImpl
    extends AutoUriImpl
    implements EntityUri {
        private final Class<?> mKlass;
        private final String mIdColumnName;
        private final long mId;

        EntityUriImpl(Class<?> klass, String idColumnName, long id) {
            this.mKlass = klass;
            this.mIdColumnName = idColumnName;
            this.mId = id;
        }

        EntityUriImpl(EntityUriImpl other) {
            super(other);
            this.mKlass = other.mKlass;
            this.mIdColumnName = other.mIdColumnName;
            this.mId = other.mId;
        }

        @Override
        public long getId() {
            return this.mId;
        }

        @Override
        public String getIdColumn() {
            return this.mIdColumnName;
        }

        @Override
        public Uri toUri() {
            Uri.Builder builder = new Uri.Builder().scheme("content").authority(AutoUris.this.mAuthority).appendPath(AutoUris.this.mClassToTableMap.getTableForClass(this.getModelUri().getModel())).appendPath(String.valueOf(this.getId()));
            this.appendRelationsAsParams(builder);
            if (!AutoUris.this.mIdColumnName.equals(this.mIdColumnName)) {
                builder.appendQueryParameter(AutoUris.ID_COLUMN_QUERY_PARAM, this.mIdColumnName);
            }
            return builder.build();
        }

        @Override
        public ModelUri getModelUri() {
            return new ModelUriImpl(this.mKlass);
        }

        @Override
        public Class<?> getModel() {
            return this.mKlass;
        }

        @Override
        public <T> T accept(AutoUriVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public EntityUri relatedTo(EntityUri uri) {
            return this.handleRelatedTo((Optional<String>)Optional.absent(), uri, new EntityUriImpl(this), true);
        }

        @Override
        public EntityUri relatedTo(String relationColumn, EntityUri uri) {
            return this.handleRelatedTo((Optional<String>)Optional.of((Object)relationColumn), uri, new EntityUriImpl(this), true);
        }

        @Override
        public ModelUri model(Class<?> klass) {
            return (ModelUri)AutoUris.this.model(klass).relatedTo(this);
        }

        @Override
        public CustomUri path(Object path) {
            return (CustomUri)new CustomUriImpl().path(path).relatedTo(this);
        }

        @Override
        public CustomUri path(Class<?> model) {
            return (CustomUri)new CustomUriImpl().path(model).relatedTo(this);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mKlass, this.mIdColumnName, this.mId, super.hashCode()});
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            EntityUriImpl other = (EntityUriImpl)obj;
            return Objects.equal(this.mKlass, other.mKlass) && Objects.equal((Object)this.mIdColumnName, (Object)other.mIdColumnName) && Objects.equal((Object)this.mId, (Object)other.mId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", this.mId).add(AutoUris.ID_COLUMN_QUERY_PARAM, (Object)this.mIdColumnName).add("model", (Object)this.getModelUri().getModel().getSimpleName()).add(AutoUris.RELATED_TO_QUERY_PARAM, (Object)Joiner.on((String)", ").join((Iterable)this.mRelatedEntities.values())).toString();
        }
    }

    private class ModelUriImpl
    extends AutoUriImpl
    implements ModelUri {
        final Class<?> mKlass;

        ModelUriImpl(Class<?> klass) {
            this.mKlass = klass;
        }

        ModelUriImpl(ModelUriImpl other) {
            super(other);
            this.mKlass = other.mKlass;
        }

        @Override
        public Class<?> getModel() {
            return this.mKlass;
        }

        @Override
        public <T> T accept(AutoUriVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public Uri toUri() {
            Uri.Builder builder = new Uri.Builder().scheme("content").authority(AutoUris.this.mAuthority);
            if (!this.appendRelationsAsPath(builder)) {
                this.appendRelationsAsParams(builder);
            }
            return builder.appendPath(AutoUris.this.mClassToTableMap.getTableForClass(this.getModel())).build();
        }

        @Override
        public ModelUri getModelUri() {
            return this;
        }

        @Override
        public ModelUri relatedTo(EntityUri uri) {
            return this.handleRelatedTo((Optional<String>)Optional.absent(), uri, new ModelUriImpl(this), true);
        }

        @Override
        public ModelUri relatedTo(String relationColumn, EntityUri uri) {
            return this.handleRelatedTo((Optional<String>)Optional.of((Object)relationColumn), uri, new ModelUriImpl(this), true);
        }

        @Override
        public EntityUri id(long id) {
            return this.id(AutoUris.this.mIdColumnName, id);
        }

        @Override
        public EntityUri id(String column, long id) {
            EntityUriImpl entityUri = new EntityUriImpl(this.mKlass, column, id);
            entityUri.mRelatedEntities.putAll(this.mRelatedEntities);
            return entityUri;
        }

        @Override
        public CustomUri path(Object path) {
            CustomUriImpl customUri = new CustomUriImpl();
            customUri.mRelatedEntities = HashBasedTable.create((Table)this.mRelatedEntities);
            return customUri.model(this.getModel()).path(path);
        }

        @Override
        public CustomUri path(Class<?> model) {
            CustomUriImpl customUri = new CustomUriImpl();
            customUri.mRelatedEntities = HashBasedTable.create((Table)this.mRelatedEntities);
            return customUri.model(this.getModel()).path(model);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mKlass, super.hashCode()});
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            ModelUriImpl other = (ModelUriImpl)obj;
            return Objects.equal(this.mKlass, other.mKlass);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("model", (Object)this.getModel().getSimpleName()).add(AutoUris.RELATED_TO_QUERY_PARAM, (Object)Joiner.on((String)", ").join((Iterable)this.mRelatedEntities.values())).toString();
        }
    }

    private class CustomUriImpl
    extends AutoUriImpl
    implements CustomUri {
        private final LinkedList<String> pathSegments;

        private CustomUriImpl() {
            this.pathSegments = Lists.newLinkedList();
        }

        private CustomUriImpl(CustomUriImpl other) {
            super(other);
            this.pathSegments = new LinkedList<String>(other.pathSegments);
        }

        @Override
        public CustomUri model(Class<?> model) {
            Preconditions.checkNotNull(model);
            Preconditions.checkArgument((boolean)AutoUris.this.mClassToTableMap.hasClass(model), (String)"Model %s is not present in supplied model graph", (Object[])new Object[]{model.getSimpleName()});
            CustomUriImpl customUri = new CustomUriImpl(this);
            customUri.pathSegments.add(AutoUris.this.mClassToTableMap.getTableForClass(model));
            return customUri;
        }

        @Override
        public CustomUri id(long id) {
            return this.path(id);
        }

        @Override
        public CustomUri path(Object path) {
            Preconditions.checkNotNull((Object)path);
            Preconditions.checkArgument((!AutoUris.this.mClassToTableMap.hasTable(path.toString()) ? 1 : 0) != 0, (String)"%s is reserved for model(%s.class) and path(%s.class) calls", (Object[])new Object[]{path.toString(), AutoUris.this.mClassToTableMap.getClassForTable(path.toString()), AutoUris.this.mClassToTableMap.getClassForTable(path.toString())});
            CustomUriImpl customUri = new CustomUriImpl(this);
            customUri.pathSegments.add(path.toString());
            return customUri;
        }

        @Override
        public CustomUri path(Class<?> model) {
            Preconditions.checkNotNull(model);
            Preconditions.checkArgument((boolean)AutoUris.this.mClassToTableMap.hasClass(model), (String)"Model %s is not present in supplied model graph", (Object[])new Object[]{model.getSimpleName()});
            CustomUriImpl customUri = new CustomUriImpl(this);
            customUri.pathSegments.add(AutoUris.this.mClassToTableMap.getTableForClass(model));
            return customUri;
        }

        @Override
        public Uri toUri() {
            Uri.Builder builder = new Uri.Builder().scheme("content").authority(AutoUris.this.mAuthority);
            if (!this.appendRelationsAsPath(builder)) {
                this.appendRelationsAsParams(builder);
            }
            for (String pathSegment : this.pathSegments) {
                builder.appendPath(pathSegment);
            }
            return builder.build();
        }

        @Override
        public ModelUri getModelUri() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> getModel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T accept(AutoUriVisitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public CustomUri relatedTo(EntityUri uri) {
            return this.handleRelatedTo((Optional<String>)Optional.absent(), uri, new CustomUriImpl(this), false);
        }

        @Override
        public CustomUri relatedTo(String relationColumn, EntityUri uri) {
            return this.handleRelatedTo((Optional<String>)Optional.of((Object)relationColumn), uri, new CustomUriImpl(this), false);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.pathSegments, super.hashCode()});
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            CustomUriImpl other = (CustomUriImpl)obj;
            return Objects.equal(this.pathSegments, other.pathSegments);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("path", (Object)Joiner.on((String)"/").join(this.pathSegments)).add(AutoUris.RELATED_TO_QUERY_PARAM, (Object)Joiner.on((String)", ").join((Iterable)this.mRelatedEntities.values())).toString();
        }
    }

    private abstract class AutoUriImpl
    implements AutoUri {
        protected Table<Class<?>, Optional<String>, EntityRelation> mRelatedEntities;

        protected AutoUriImpl() {
            this.mRelatedEntities = HashBasedTable.create();
        }

        protected AutoUriImpl(AutoUriImpl other) {
            this.mRelatedEntities = HashBasedTable.create(other.mRelatedEntities);
        }

        @Override
        public Collection<EntityRelation> getRelatedEntities() {
            return Lists.newCopyOnWriteArrayList((Iterable)this.mRelatedEntities.values());
        }

        @Override
        public Optional<EntityRelation> getRelatedEntity(Class<?> model) {
            Preconditions.checkNotNull(model);
            return Optional.fromNullable((Object)this.mRelatedEntities.get(model, (Object)Optional.absent()));
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mRelatedEntities});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AutoUriImpl other = (AutoUriImpl)obj;
            return Objects.equal(this.mRelatedEntities, other.mRelatedEntities);
        }

        protected boolean appendRelationsAsPath(Uri.Builder builder) {
            if (this.mRelatedEntities.size() == 1) {
                EntityRelation entityRelation = (EntityRelation)this.mRelatedEntities.values().iterator().next();
                if (entityRelation.entityUri.getIdColumn().equals(AutoUris.this.mIdColumnName) && entityRelation.entityUri.getRelatedEntities().isEmpty() && !entityRelation.relationColumn.isPresent()) {
                    builder.appendPath(AutoUris.this.mClassToTableMap.getTableForClass(entityRelation.entityUri.getModelUri().getModel())).appendPath(String.valueOf(entityRelation.entityUri.getId()));
                    return true;
                }
            }
            return false;
        }

        protected void appendRelationsAsParams(Uri.Builder builder) {
            for (EntityRelation entityRelation : this.mRelatedEntities.values()) {
                builder.appendQueryParameter(AutoUris.RELATED_TO_QUERY_PARAM, entityRelation.toParameterString());
            }
        }

        protected <T extends AutoUriImpl> T handleRelatedTo(Optional<String> relationColumnOptional, EntityUri relatedUri, T uri, boolean validateRelations) {
            Preconditions.checkNotNull(uri);
            Class<?> relationModel = relatedUri.getModelUri().getModel();
            if (relationColumnOptional.isPresent()) {
                EntityRelation previousValue;
                String relationColumn = (String)relationColumnOptional.get();
                if (validateRelations) {
                    Class<?> model = uri.getModel();
                    Set relationColumns = (Set)AutoUris.this.mRelationsByClasses.get(model, relationModel);
                    Preconditions.checkArgument((relationColumns != null && relationColumns.contains(relationColumn) ? 1 : 0) != 0, (String)"No relation found between %s and %s.%s", (Object[])new Object[]{model.getSimpleName(), relationModel.getSimpleName(), relationColumn});
                }
                Preconditions.checkArgument(((previousValue = (EntityRelation)uri.mRelatedEntities.put(relationModel, relationColumnOptional, (Object)new EntityRelation(relationColumn, relatedUri))) == null ? 1 : 0) != 0, (String)"Duplicate relation for model %s.%s", (Object[])new Object[]{relationModel.getSimpleName(), relationColumn});
            } else {
                EntityRelation previousValue;
                if (validateRelations) {
                    Class<?> model = uri.getModel();
                    Set relationColumns = (Set)AutoUris.this.mRelationsByClasses.get(model, relationModel);
                    Preconditions.checkArgument((relationColumns != null ? 1 : 0) != 0, (String)"No relation found between %s and %s", (Object[])new Object[]{model.getSimpleName(), relationModel.getSimpleName()});
                    Preconditions.checkArgument((relationColumns.size() == 1 ? 1 : 0) != 0, (String)"Ambiguous relation between %s and %s", (Object[])new Object[]{model.getSimpleName(), relationModel.getSimpleName()});
                }
                Preconditions.checkArgument(((previousValue = (EntityRelation)uri.mRelatedEntities.put(relationModel, relationColumnOptional, (Object)new EntityRelation(relatedUri))) == null ? 1 : 0) != 0, (String)"Duplicate relation for model %s", (Object[])new Object[]{relationModel.getSimpleName()});
            }
            return uri;
        }
    }

    public static interface AuthoritySelector<TModel extends DatabaseModel & PojoModel> {
        public Builder<TModel> forContentProvider(String var1);
    }

    public static class Builder<TModel extends DatabaseModel & PojoModel>
    implements AuthoritySelector<TModel> {
        private final ModelGraph<TModel> mModelGraph;
        private final ClassToTable<TModel> mClassToTable;
        private String mIdColumnName = "_id";
        private String mAuthority;

        Builder(ModelGraph<TModel> modelGraph, ClassToTable<TModel> classToTable) {
            this.mModelGraph = modelGraph;
            this.mClassToTable = classToTable;
        }

        public Builder<TModel> defaultIdColumn(String idColumnName) {
            this.mIdColumnName = idColumnName;
            return this;
        }

        public AutoUris<TModel> build() {
            return new AutoUris<TModel>(this.mModelGraph, this.mClassToTable, this.mAuthority, this.mIdColumnName);
        }

        @Override
        public Builder<TModel> forContentProvider(String authority) {
            this.mAuthority = authority;
            return this;
        }
    }
}

