/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.android.autoprovider;

import android.content.ContentValues;
import android.database.sqlite.SQLiteOpenHelper;
import com.getbase.android.autoprovider.AutoUri;
import com.getbase.android.autoprovider.AutoUriVisitor;
import com.getbase.android.autoprovider.CustomUri;
import com.getbase.android.autoprovider.EntityRelation;
import com.getbase.android.autoprovider.EntityUri;
import com.getbase.android.autoprovider.ModelUri;
import com.getbase.android.autoprovider.Utils;
import com.getbase.android.db.cursors.SingleRowTransforms;
import com.getbase.android.db.fluentsqlite.Delete;
import com.getbase.android.db.fluentsqlite.Expressions;
import com.getbase.android.db.fluentsqlite.Insert;
import com.getbase.android.db.fluentsqlite.Query;
import com.getbase.android.db.fluentsqlite.Update;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chalup.thneed.ManyToManyRelationship;
import org.chalup.thneed.ModelGraph;
import org.chalup.thneed.OneToManyRelationship;
import org.chalup.thneed.OneToOneRelationship;
import org.chalup.thneed.PolymorphicRelationship;
import org.chalup.thneed.RecursiveModelRelationship;
import org.chalup.thneed.RelationshipVisitor;
import org.chalup.thneed.models.DatabaseModel;
import org.chalup.thneed.models.PojoModel;

public class CrudOperationsResolver {
    private final BiMap<Class<?>, String> mClassToTableMap;
    private final Table<Class<?>, Class<?>, Map<String, CrudDataProcessor>> mCrudDataProcessors;
    private final SQLiteOpenHelper mDatabase;
    private final AutoUriVisitor<Query.QueryBuilder> mQueryBuilderVisitor = new AutoUriVisitor<Query.QueryBuilder>(){

        @Override
        public Query.QueryBuilder visit(EntityUri uri) {
            return this.getQueryBuilder(uri).where((Expressions.Expression)Expressions.column((String)uri.getIdColumn()).eq().literal((Number)uri.getId()), new Object[0]);
        }

        @Override
        public Query.QueryBuilder visit(ModelUri uri) {
            return this.getQueryBuilder(uri);
        }

        @Override
        public Query.QueryBuilder visit(CustomUri uri) {
            throw new UnsupportedOperationException(uri.toString());
        }

        private Query.QueryBuilder getQueryBuilder(AutoUri uri) {
            Query.TableAliasBuilder queryBuilder = Query.select().from((String)CrudOperationsResolver.this.mClassToTableMap.get(uri.getModel()));
            if (!uri.getRelatedEntities().isEmpty()) {
                for (Expressions.Expression expression : CrudOperationsResolver.this.getSelection(uri)) {
                    queryBuilder.where(expression, new Object[0]);
                }
            }
            return queryBuilder;
        }
    };
    private final AutoUriVisitor<Update> mUpdateVisitor = new AutoUriVisitor<Update>(){

        @Override
        public Update visit(EntityUri uri) {
            return this.getUpdate(uri).where(uri.getIdColumn() + "=?", (Object[])new Long[]{uri.getId()});
        }

        @Override
        public Update visit(ModelUri uri) {
            return this.getUpdate(uri);
        }

        @Override
        public Update visit(CustomUri uri) {
            throw new UnsupportedOperationException(uri.toString());
        }

        private Update getUpdate(AutoUri uri) {
            Update update = Update.update().table((String)CrudOperationsResolver.this.mClassToTableMap.get(uri.getModel()));
            if (!uri.getRelatedEntities().isEmpty()) {
                for (Expressions.Expression expression : CrudOperationsResolver.this.getSelection(uri)) {
                    update = update.where(expression, new Object[0]);
                }
            }
            return update;
        }
    };
    private final AutoUriVisitor<Insert> mInsertVisitor = new AutoUriVisitor<Insert>(){
        private final ContentValues EMPTY_VALUES = new ContentValues();

        @Override
        public Insert visit(EntityUri uri) {
            return this.getInsert(uri).value(uri.getIdColumn(), (Object)uri.getId());
        }

        @Override
        public Insert visit(ModelUri uri) {
            return this.getInsert(uri);
        }

        @Override
        public Insert visit(CustomUri uri) {
            throw new UnsupportedOperationException(uri.toString());
        }

        private Insert getInsert(AutoUri uri) {
            Insert insert = Insert.insert().into((String)CrudOperationsResolver.this.mClassToTableMap.get(uri.getModel())).values(this.EMPTY_VALUES);
            if (!uri.getRelatedEntities().isEmpty()) {
                insert = insert.values(CrudOperationsResolver.this.getValues(uri));
            }
            return insert;
        }
    };
    private final AutoUriVisitor<Delete> mDeleteVisitor = new AutoUriVisitor<Delete>(){

        @Override
        public Delete visit(EntityUri uri) {
            return this.getDelete(uri).where(uri.getIdColumn() + "=?", (Object[])new Long[]{uri.getId()});
        }

        @Override
        public Delete visit(ModelUri uri) {
            return this.getDelete(uri);
        }

        @Override
        public Delete visit(CustomUri uri) {
            throw new UnsupportedOperationException(uri.toString());
        }

        private Delete getDelete(AutoUri uri) {
            Delete delete = Delete.delete().from((String)CrudOperationsResolver.this.mClassToTableMap.get(uri.getModel()));
            if (!uri.getRelatedEntities().isEmpty()) {
                for (Expressions.Expression expression : CrudOperationsResolver.this.getSelection(uri)) {
                    delete = delete.where(expression, new Object[0]);
                }
            }
            return delete;
        }
    };
    private final AutoUriVisitor<Set<Class<?>>> mRelatedModelsVisitor = new AutoUriVisitor<Set<Class<?>>>(){

        @Override
        public Set<Class<?>> visit(EntityUri uri) {
            return this.getRelatedModels(uri.getModel());
        }

        @Override
        public Set<Class<?>> visit(ModelUri uri) {
            return this.getRelatedModels(uri.getModel());
        }

        @Override
        public Set<Class<?>> visit(CustomUri uri) {
            throw new UnsupportedOperationException(uri.toString());
        }

        private Set<Class<?>> getRelatedModels(Class<?> model) {
            if (CrudOperationsResolver.this.mCrudDataProcessors.containsColumn(model)) {
                Set<Class<?>> relatedModels = CrudOperationsResolver.this.mCrudDataProcessors.column(model).keySet();
                return relatedModels;
            }
            return null;
        }
    };

    private void addCrudDataProcessor(Table<Class<?>, Class<?>, Map<String, CrudDataProcessor>> crudDataProcessors, Class<?> modelClass, Class<?> referencedModelClass, String columnName, CrudDataProcessor crudDataProcessor) {
        Map crudDataProcessorsMap = (Map)crudDataProcessors.get(modelClass, referencedModelClass);
        if (crudDataProcessorsMap == null) {
            crudDataProcessorsMap = Maps.newHashMap();
            crudDataProcessors.put(modelClass, referencedModelClass, (Object)crudDataProcessorsMap);
        }
        crudDataProcessorsMap.put(columnName, crudDataProcessor);
    }

    private List<Expressions.Expression> getSelection(AutoUri uri) {
        ArrayList expressions = Lists.newArrayList();
        for (EntityRelation entityRelation : uri.getRelatedEntities()) {
            Map processorMap = (Map)this.mCrudDataProcessors.get(uri.getModel(), entityRelation.entityUri.getModel());
            if (entityRelation.relationColumn.isPresent()) {
                ((CrudDataProcessor)((Map)this.mCrudDataProcessors.get(uri.getModel(), entityRelation.entityUri.getModel())).get(entityRelation.relationColumn.get())).processSelection(expressions, entityRelation.entityUri);
                continue;
            }
            if (processorMap.size() == 1) {
                ((CrudDataProcessor)((Map)this.mCrudDataProcessors.get(uri.getModel(), entityRelation.entityUri.getModel())).values().iterator().next()).processSelection(expressions, entityRelation.entityUri);
                continue;
            }
            throw new IllegalArgumentException("Ambiguous relation for uri: " + uri.toUri().toString());
        }
        return expressions;
    }

    private ContentValues getValues(AutoUri uri) {
        ContentValues values = new ContentValues();
        for (EntityRelation entityRelation : uri.getRelatedEntities()) {
            Map processorMap = (Map)this.mCrudDataProcessors.get(uri.getModel(), entityRelation.entityUri.getModel());
            if (entityRelation.relationColumn.isPresent()) {
                ((CrudDataProcessor)((Map)this.mCrudDataProcessors.get(uri.getModel(), entityRelation.entityUri.getModel())).get(entityRelation.relationColumn.get())).processValues(values, entityRelation.entityUri);
                continue;
            }
            if (processorMap.size() == 1) {
                ((CrudDataProcessor)((Map)this.mCrudDataProcessors.get(uri.getModel(), entityRelation.entityUri.getModel())).values().iterator().next()).processValues(values, entityRelation.entityUri);
                continue;
            }
            throw new IllegalArgumentException("Ambiguous relation for uri: " + uri.toUri().toString());
        }
        return values;
    }

    public <TModel extends DatabaseModel & PojoModel> CrudOperationsResolver(SQLiteOpenHelper database, ModelGraph<TModel> modelGraph) {
        this.mDatabase = database;
        this.mClassToTableMap = Utils.buildClassToTableMap(modelGraph);
        HashBasedTable crudDataProcessors = HashBasedTable.create();
        modelGraph.accept(new RelationshipVisitor<TModel>((Table)crudDataProcessors){
            final /* synthetic */ Table val$crudDataProcessors;
            {
                this.val$crudDataProcessors = table;
            }

            public void visit(final OneToManyRelationship<? extends TModel> relationship) {
                DatabaseModel model = (DatabaseModel)relationship.mModel;
                DatabaseModel referencedModel = (DatabaseModel)relationship.mReferencedModel;
                CrudOperationsResolver.this.addCrudDataProcessor(this.val$crudDataProcessors, ((PojoModel)model).getModelClass(), ((PojoModel)referencedModel).getModelClass(), relationship.mLinkedByColumn, new CrudDataProcessor(){

                    @Override
                    public void processSelection(List<Expressions.Expression> expressions, EntityUri relatedEntity) {
                        if (relatedEntity.getIdColumn().equals(relationship.mReferencedModelIdColumn)) {
                            expressions.add((Expressions.Expression)Expressions.column((String)relationship.mLinkedByColumn).eq().literal((Number)relatedEntity.getId()));
                        } else {
                            expressions.add((Expressions.Expression)Expressions.column((String)relationship.mLinkedByColumn).in((Query.QueryBuilder)((Query.QueryBuilder)relatedEntity.accept(CrudOperationsResolver.this.mQueryBuilderVisitor)).column(relationship.mReferencedModelIdColumn)));
                        }
                    }

                    @Override
                    public void processValues(ContentValues values, EntityUri relatedEntity) {
                        if (relatedEntity.getIdColumn().equals(relationship.mReferencedModelIdColumn)) {
                            values.put(relationship.mLinkedByColumn, Long.valueOf(relatedEntity.getId()));
                        } else {
                            String id = (String)((Query.QueryBuilder)CrudOperationsResolver.this.mQueryBuilderVisitor.visit(relatedEntity)).column(relationship.mReferencedModelIdColumn).perform(CrudOperationsResolver.this.mDatabase.getReadableDatabase()).toOnlyElement(SingleRowTransforms.getColumn((String)relationship.mReferencedModelIdColumn).asString());
                            values.put(relationship.mLinkedByColumn, id);
                        }
                    }
                });
            }

            public void visit(final OneToOneRelationship<? extends TModel> relationship) {
                DatabaseModel linkedModel = (DatabaseModel)relationship.mLinkedModel;
                DatabaseModel model = (DatabaseModel)relationship.mModel;
                CrudOperationsResolver.this.addCrudDataProcessor(this.val$crudDataProcessors, ((PojoModel)linkedModel).getModelClass(), ((PojoModel)model).getModelClass(), relationship.mLinkedByColumn, new CrudDataProcessor(){

                    @Override
                    public void processSelection(List<Expressions.Expression> expressions, EntityUri relatedEntity) {
                        if (relatedEntity.getIdColumn().equals(relationship.mParentModelIdColumn)) {
                            expressions.add((Expressions.Expression)Expressions.column((String)relationship.mLinkedByColumn).eq().literal((Number)relatedEntity.getId()));
                        } else {
                            expressions.add((Expressions.Expression)Expressions.column((String)relationship.mLinkedByColumn).in((Query.QueryBuilder)((Query.QueryBuilder)relatedEntity.accept(CrudOperationsResolver.this.mQueryBuilderVisitor)).column(relationship.mParentModelIdColumn)));
                        }
                    }

                    @Override
                    public void processValues(ContentValues values, EntityUri relatedEntity) {
                        if (relatedEntity.getIdColumn().equals(relationship.mParentModelIdColumn)) {
                            values.put(relationship.mLinkedByColumn, Long.valueOf(relatedEntity.getId()));
                        } else {
                            String id = (String)((Query.QueryBuilder)CrudOperationsResolver.this.mQueryBuilderVisitor.visit(relatedEntity)).column(relationship.mParentModelIdColumn).perform(CrudOperationsResolver.this.mDatabase.getReadableDatabase()).toOnlyElement(SingleRowTransforms.getColumn((String)relationship.mParentModelIdColumn).asString());
                            values.put(relationship.mLinkedByColumn, id);
                        }
                    }
                });
            }

            public void visit(final RecursiveModelRelationship<? extends TModel> relationship) {
                DatabaseModel model = (DatabaseModel)relationship.mModel;
                CrudOperationsResolver.this.addCrudDataProcessor(this.val$crudDataProcessors, ((PojoModel)model).getModelClass(), ((PojoModel)model).getModelClass(), relationship.mGroupByColumn, new CrudDataProcessor(){

                    @Override
                    public void processSelection(List<Expressions.Expression> expressions, EntityUri relatedEntity) {
                        if (relatedEntity.getIdColumn().equals(relationship.mModelIdColumn)) {
                            expressions.add((Expressions.Expression)Expressions.column((String)relationship.mGroupByColumn).eq().literal((Number)relatedEntity.getId()));
                        } else {
                            expressions.add((Expressions.Expression)Expressions.column((String)relationship.mGroupByColumn).in((Query.QueryBuilder)((Query.QueryBuilder)relatedEntity.accept(CrudOperationsResolver.this.mQueryBuilderVisitor)).column(relationship.mModelIdColumn)));
                        }
                    }

                    @Override
                    public void processValues(ContentValues values, EntityUri relatedEntity) {
                        if (relatedEntity.getIdColumn().equals(relationship.mModelIdColumn)) {
                            values.put(relationship.mGroupByColumn, Long.valueOf(relatedEntity.getId()));
                        } else {
                            String id = (String)((Query.QueryBuilder)CrudOperationsResolver.this.mQueryBuilderVisitor.visit(relatedEntity)).column(relationship.mModelIdColumn).perform(CrudOperationsResolver.this.mDatabase.getReadableDatabase()).toOnlyElement(SingleRowTransforms.getColumn((String)relationship.mModelIdColumn).asString());
                            values.put(relationship.mGroupByColumn, id);
                        }
                    }
                });
            }

            public void visit(ManyToManyRelationship<? extends TModel> relationship) {
            }

            public void visit(final PolymorphicRelationship<? extends TModel> relationship) {
                for (final Map.Entry polyModelEntry : relationship.mPolymorphicModels.entrySet()) {
                    DatabaseModel model = (DatabaseModel)relationship.mModel;
                    DatabaseModel polyModel = (DatabaseModel)polyModelEntry.getValue();
                    CrudOperationsResolver.this.addCrudDataProcessor(this.val$crudDataProcessors, ((PojoModel)model).getModelClass(), ((PojoModel)polyModel).getModelClass(), relationship.mPolymorphicModelIdColumn, new CrudDataProcessor(){

                        @Override
                        public void processSelection(List<Expressions.Expression> expressions, EntityUri relatedEntity) {
                            expressions.add((Expressions.Expression)Expressions.column((String)relationship.mTypeColumnName).eq().literal(polyModelEntry.getKey()));
                            if (relatedEntity.getIdColumn().equals(relationship.mPolymorphicModelIdColumn)) {
                                expressions.add((Expressions.Expression)Expressions.column((String)relationship.mIdColumnName).eq().literal((Number)relatedEntity.getId()));
                            } else {
                                expressions.add((Expressions.Expression)Expressions.column((String)relationship.mIdColumnName).in((Query.QueryBuilder)((Query.QueryBuilder)relatedEntity.accept(CrudOperationsResolver.this.mQueryBuilderVisitor)).column(relationship.mPolymorphicModelIdColumn)));
                            }
                        }

                        @Override
                        public void processValues(ContentValues values, EntityUri relatedEntity) {
                            values.put(relationship.mTypeColumnName, (String)polyModelEntry.getKey());
                            if (relatedEntity.getIdColumn().equals(relationship.mPolymorphicModelIdColumn)) {
                                values.put(relationship.mIdColumnName, Long.valueOf(relatedEntity.getId()));
                            } else {
                                String id = (String)((Query.QueryBuilder)CrudOperationsResolver.this.mQueryBuilderVisitor.visit(relatedEntity)).column(relationship.mPolymorphicModelIdColumn).perform(CrudOperationsResolver.this.mDatabase.getReadableDatabase()).toOnlyElement(SingleRowTransforms.getColumn((String)relationship.mPolymorphicModelIdColumn).asString());
                                values.put(relationship.mIdColumnName, id);
                            }
                        }
                    });
                }
            }
        });
        this.mCrudDataProcessors = ImmutableTable.copyOf((Table)crudDataProcessors);
    }

    public AutoUriVisitor<Query.QueryBuilder> getQueryBuilderVisitor() {
        return this.mQueryBuilderVisitor;
    }

    public AutoUriVisitor<Update> getUpdateVisitor() {
        return this.mUpdateVisitor;
    }

    public AutoUriVisitor<Insert> getInsertVisitor() {
        return this.mInsertVisitor;
    }

    public AutoUriVisitor<Delete> getDeleteVisitor() {
        return this.mDeleteVisitor;
    }

    public AutoUriVisitor<Set<Class<?>>> getRelatedModelsVisitor() {
        return this.mRelatedModelsVisitor;
    }

    private static interface CrudDataProcessor {
        public void processSelection(List<Expressions.Expression> var1, EntityUri var2);

        public void processValues(ContentValues var1, EntityUri var2);
    }
}

