/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.android.autoprovider;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.database.ContentObservable;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.net.Uri;
import android.os.Build;
import com.google.common.collect.Iterables;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class MultiUriCursorWrapper
extends CursorWrapper {
    protected boolean mClosed;
    protected ContentResolver mContentResolver;
    private final Set<Uri> mNotifyUris = new CopyOnWriteArraySet<Uri>();
    private final Object mSelfObserverLock = new Object();
    private ContentObserver mSelfObserver;
    private boolean mSelfObserverRegistered;
    private final LinkedHashSet<Uri> mChangedByUris = new LinkedHashSet();
    private final ContentObservable mContentObservable = new ContentObservable();

    public MultiUriCursorWrapper(Cursor cursor) {
        super(cursor);
    }

    public void deactivate() {
        this.onDeactivateOrClose();
        super.deactivate();
    }

    protected void onDeactivateOrClose() {
        if (this.mSelfObserver != null) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            this.mSelfObserverRegistered = false;
        }
    }

    public boolean requery() {
        boolean success;
        if (this.mSelfObserver != null && !this.mSelfObserverRegistered) {
            for (Uri notifyUri : this.mNotifyUris) {
                this.mContentResolver.registerContentObserver(notifyUri, true, this.mSelfObserver);
            }
            this.mSelfObserverRegistered = true;
        }
        if (success = super.requery()) {
            this.mChangedByUris.clear();
        }
        return success;
    }

    public boolean isClosed() {
        return super.isClosed() && this.mClosed;
    }

    public void close() {
        super.close();
        this.mClosed = true;
        this.mContentObservable.unregisterAll();
        this.onDeactivateOrClose();
    }

    public void registerContentObserver(ContentObserver observer) {
        this.mContentObservable.registerObserver(observer);
        if (Build.VERSION.SDK_INT >= 16) {
            this.dispatchChangeForUris(observer);
        } else if (!this.mChangedByUris.isEmpty()) {
            observer.dispatchChange(false);
        }
    }

    @TargetApi(value=16)
    private void dispatchChangeForUris(ContentObserver observer) {
        for (Uri changedByUri : new ArrayList<Uri>(this.mChangedByUris)) {
            observer.dispatchChange(false, changedByUri);
        }
    }

    public void unregisterContentObserver(ContentObserver observer) {
        if (!this.mClosed) {
            this.mContentObservable.unregisterObserver((Object)observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    private void onChange(boolean selfChange, Uri uri) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.mContentObservable.dispatchChange(selfChange, uri);
            } else {
                this.mContentObservable.dispatchChange(selfChange);
            }
            if (selfChange) {
                for (Uri notifyUri : this.mNotifyUris) {
                    this.mContentResolver.notifyChange(notifyUri, this.mSelfObserver);
                }
            }
            if (!selfChange) {
                this.mChangedByUris.add(uri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiUriCursorWrapper withNotificationUris(ContentResolver cr, Collection<Uri> uris) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mNotifyUris.addAll(uris);
            this.mContentResolver = cr;
            if (this.mSelfObserver == null) {
                this.mSelfObserver = new SelfContentObserver(this);
            }
            for (Uri uri : uris) {
                this.mContentResolver.registerContentObserver(uri, true, this.mSelfObserver);
            }
            this.mSelfObserverRegistered = true;
        }
        return this;
    }

    public MultiUriCursorWrapper withNotificationUri(ContentResolver cr, Uri uri) {
        return this.withNotificationUris(cr, Collections.singletonList(uri));
    }

    public Set<Uri> getNotificationUris() {
        return this.mNotifyUris;
    }

    public void setNotificationUri(ContentResolver cr, Uri notifyUri) {
        this.withNotificationUri(cr, notifyUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri getNotificationUri() {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            return (Uri)Iterables.getFirst(this.mNotifyUris, null);
        }
    }

    protected void finalize() {
        try {
            super.finalize();
            if (this.mSelfObserver != null && this.mSelfObserverRegistered) {
                this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            }
            if (!this.mClosed) {
                this.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class SelfContentObserver
    extends ContentObserver {
        WeakReference<MultiUriCursorWrapper> mCursor;

        public SelfContentObserver(MultiUriCursorWrapper cursor) {
            super(null);
            this.mCursor = new WeakReference<MultiUriCursorWrapper>(cursor);
        }

        public boolean deliverSelfNotifications() {
            return false;
        }

        public void onChange(boolean selfChange, Uri uri) {
            MultiUriCursorWrapper cursor = (MultiUriCursorWrapper)((Object)this.mCursor.get());
            if (cursor != null) {
                cursor.onChange(false, uri);
            }
        }

        public void onChange(boolean selfChange) {
            this.onChange(selfChange, null);
        }
    }
}

