/*
 * Decompiled with CFR 0.152.
 */
package com.getbase.android.autoprovider;

import com.getbase.android.autoprovider.SqliteSchemaHelper;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Locale;

public class SqliteQueryTablesFinder {
    private final SqliteSchemaHelper mSchemaHelper;

    public SqliteQueryTablesFinder(SqliteSchemaHelper schemaHelper) {
        this.mSchemaHelper = schemaHelper;
    }

    public ImmutableSet<String> getTablesFromRawSql(String rawSql) {
        final String sql = rawSql.toLowerCase(Locale.US);
        return FluentIterable.from((Iterable)Iterables.concat(this.mSchemaHelper.getTables(), this.mSchemaHelper.getViews())).filter((Predicate)new Predicate<String>(){

            public boolean apply(String tableOrView) {
                return sql.contains(tableOrView);
            }
        }).toSet();
    }
}

